/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.sound.human;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yzqdev.mod.jeanmod.JeanMod;
import com.yzqdev.mod.jeanmod.sound.ModSoundEvents;
import com.yzqdev.mod.jeanmod.sound.SoundCache;
import com.yzqdev.mod.jeanmod.sound.SoundConstant;
import com.yzqdev.mod.jeanmod.sound.SoundData;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.sounds.JOrbisAudioStream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class HumanSoundLoader {
    public static final Map<String, SoundCache> CACHE = Maps.newLinkedHashMap();
    private static final Marker MARKER = MarkerManager.getMarker((String)"HumanSoundLoader");

    public static void clear() {
        CACHE.clear();
    }

    public static SoundCache getSoundCache(String id) {
        return CACHE.get(id);
    }

    public static List<String> getSoundIds() {
        if (Files.exists(SoundConstant.SKIRK_SOUND_FOLDER, new LinkOption[0])) {
            return Arrays.stream(SoundConstant.SKIRK_SOUND_FOLDER.toFile().listFiles()).filter(File::isDirectory).map(File::getName).toList();
        }
        return Lists.newArrayList();
    }

    public static void loadHumanSounds() {
        if (Files.exists(SoundConstant.SKIRK_SOUND_FOLDER, new LinkOption[0])) {
            try {
                Files.walk(SoundConstant.SKIRK_SOUND_FOLDER, 1, new FileVisitOption[0]).filter(i -> Files.isDirectory(i, new LinkOption[0]) && !i.getFileName().toString().contains("sounds")).forEach(file -> {
                    String id = file.getFileName().toString();
                    SoundCache soundCache = new SoundCache(HumanSoundLoader.loadSoundEvents(file));
                    CACHE.put(id, soundCache);
                });
            }
            catch (Exception e) {
                JeanMod.LOGGER.error(MARKER, "Failed to load Human Sound Cache", (Throwable)e);
            }
        }
    }

    private static Map<ResourceLocation, List<SoundData>> loadSoundEvents(Path soundFolder) {
        LinkedHashMap buffers = Maps.newLinkedHashMap();
        File[] files = soundFolder.toFile().listFiles();
        if (files == null || files.length == 0) {
            return buffers;
        }
        for (File file : files) {
            HumanSoundLoader.loadSounds(buffers, file);
        }
        return buffers;
    }

    private static void loadSounds(Map<ResourceLocation, List<SoundData>> buffers, File soundPath) {
        List sounds = buffers.computeIfAbsent(((SoundEvent)ModSoundEvents.HUMAN_HURT.get()).getLocation(), res -> Lists.newArrayList());
        if (SoundConstant.checkOggFile(soundPath.toString())) {
            try (FileInputStream inputStream = new FileInputStream(soundPath);
                 JOrbisAudioStream audioStream = new JOrbisAudioStream((InputStream)inputStream);){
                ByteBuffer bytebuffer = audioStream.readAll();
                sounds.add(new SoundData(bytebuffer, audioStream.getFormat()));
                JeanMod.LOGGER.debug(MARKER, "sound: {}", (Object)soundPath);
            }
            catch (IOException exception) {
                JeanMod.LOGGER.error(MARKER, "Failed to load Human Sound Cache", (Throwable)exception);
            }
        }
    }
}

