/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.util;

import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;

public class ItemUtil {
    public static Item getRandomItem() {
        List itemKeys = BuiltInRegistries.ITEM.keySet().stream().toList();
        if (itemKeys.isEmpty()) {
            return null;
        }
        Random random = new Random();
        int randomIndex = random.nextInt(itemKeys.size());
        return (Item)BuiltInRegistries.ITEM.get((ResourceLocation)itemKeys.get(randomIndex));
    }

    public static void dropItem(Level level, ItemStack stack, LivingEntity entity) {
        if (!stack.isEmpty()) {
            ItemStack droppedStack = stack.copy();
            level.addFreshEntity((Entity)new ItemEntity(entity.level(), entity.getX(), entity.getY(), entity.getZ(), droppedStack));
            stack.setCount(0);
        }
    }

    public static void dropItemRandom(Level level, ItemStack stack, LivingEntity entity) {
        if (!stack.isEmpty()) {
            ItemStack droppedStack = stack.copy();
            level.addFreshEntity((Entity)new ItemEntity(entity.level(), entity.getX() + 3.0, entity.getY(), entity.getZ(), droppedStack));
            stack.setCount(0);
        }
    }

    public static ItemStack transferItem(ItemStack stack, IItemHandler handler) {
        ItemStack remaining = stack.copy();
        for (int slot = 1; slot < handler.getSlots() + 1 && !(remaining = handler.insertItem(slot, remaining, false)).isEmpty(); ++slot) {
        }
        return remaining;
    }

    public static <TYPE> Collection<ResourceLocation> getTags(Stream<TagKey<TYPE>> tags) {
        return tags.map(TagKey::location).collect(Collectors.toUnmodifiableSet());
    }
}

