/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="jean", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.BooleanValue LOG_DIRT_BLOCK = BUILDER.comment("Whether to log the dirt block on common setup").define("logDirtBlock", true);
    private static final ForgeConfigSpec.IntValue MAGIC_NUMBER = BUILDER.comment("A magic number").defineInRange("magicNumber", 42, 0, Integer.MAX_VALUE);
    public static final ForgeConfigSpec.ConfigValue<Boolean> AllowBoth = BUILDER.comment("If enabled then the Shift Right Click interaction will not be disabled when the interaction Key is binded").define("AllowBoth", false);
    public static final ForgeConfigSpec.ConfigValue<String> MAGIC_NUMBER_INTRODUCTION = BUILDER.comment("What you want the introduction message to be for the magic number").define("magicNumberIntroduction", (Object)"The magic number is... ");
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> ITEM_STRINGS = BUILDER.comment("A list of items to log on common setup.").defineListAllowEmpty("items", List.of("minecraft:iron_ingot"), Config::validateItemName);
    private static ForgeConfigSpec.BooleanValue ShowModName = BUILDER.comment("Show mod name in tooltip.  Default: false").define("showModName", false);
    private static ForgeConfigSpec.BooleanValue ShowNBTLength = BUILDER.comment("Show nbt length, in bytes, in the tooltip.  Default: true").define("showNBTLength", true);
    private static ForgeConfigSpec.BooleanValue ShowAsAdvanced = BUILDER.comment("Show NBT and Tags only if Advanced Tooltips (F3 + h) is on.  Default: false").define("showAsAdvanced", false);
    private static ForgeConfigSpec.BooleanValue ShowInfoClock = BUILDER.comment("Show Clock Day and Time.  Default: true").define("showInfoClock", true);
    private static ForgeConfigSpec.BooleanValue ShowInfoRecovery = BUILDER.comment("Show Recovery Compass players death location.  Default: true").define("showInfoRecovery", true);
    private static ForgeConfigSpec.BooleanValue ShowInfoStew = BUILDER.comment("Show Suspicious Stew effects.  Default: true").define("showInfoStew", true);
    private static ForgeConfigSpec.BooleanValue ShowInfoBees = BUILDER.comment("Show Bees Nest/Hive information.  Default: true").define("showInfoBees", true);
    private static ForgeConfigSpec.BooleanValue IsTwelves = BUILDER.comment(new String[]{"Show 12 or 24 hour clock format.  Default: false", "true for 12 hour, false for 24 hour"}).define("isTwelves", false);
    private static ForgeConfigSpec.IntValue MAID_WEIGHT = BUILDER.comment(new String[]{"maid weight"}).defineInRange("maidWeight", 3, 0, 100);
    private static ForgeConfigSpec.IntValue MAID_MIN = BUILDER.comment(new String[]{"maid min"}).defineInRange("maidMin", 1, 0, 40);
    private static ForgeConfigSpec.IntValue MAID_MAX = BUILDER.comment(new String[]{"maid max"}).defineInRange("maidMax", 1, 0, 100);
    private static ForgeConfigSpec.IntValue ELF_WEIGHT = BUILDER.comment(new String[]{"maid weight"}).defineInRange("elfWeight", 3, 0, 100);
    private static ForgeConfigSpec.IntValue ELF_MIN = BUILDER.comment(new String[]{"maid min"}).defineInRange("elfMin", 1, 0, 40);
    private static ForgeConfigSpec.IntValue ELF_MAX = BUILDER.comment(new String[]{"maid max"}).defineInRange("elfMax", 1, 0, 100);
    private static ForgeConfigSpec.IntValue GANGSTER_WEIGHT = BUILDER.comment(new String[]{"gangster weight"}).defineInRange("gangsterWeight", 3, 0, 100);
    private static ForgeConfigSpec.IntValue GANGSTER_MIN = BUILDER.comment(new String[]{"gangster min"}).defineInRange("gangsterMin", 1, 0, 40);
    private static ForgeConfigSpec.IntValue GANGSTER_MAX = BUILDER.comment(new String[]{"gangster max"}).defineInRange("gangsterMax", 1, 0, 100);
    private static ForgeConfigSpec.IntValue HUMAN_WEIGHT = BUILDER.comment(new String[]{"human  weight"}).defineInRange("humanWeight", 3, 0, 100);
    private static ForgeConfigSpec.IntValue HUMAN_MIN = BUILDER.comment(new String[]{"human  min"}).defineInRange("humanMin", 1, 0, 40);
    private static ForgeConfigSpec.IntValue HUMAN_MAX = BUILDER.comment(new String[]{"human  max"}).defineInRange("humanMax", 1, 0, 100);
    public static final ForgeConfigSpec.ConfigValue<String> DEFAULT_LITTER_CHANCES = BUILDER.comment(" pig have litter chance").define("defaultLitterChances", (Object)"30:2,50:3,15:4,4:5,1:6");
    static final ForgeConfigSpec SPEC = BUILDER.build();
    public static boolean logDirtBlock;
    public static int magicNumber;
    public static String magicNumberIntroduction;
    public static Set<Item> items;
    public static Boolean allowBoth;
    public static boolean showModName;
    public static boolean showNBTLength;
    public static boolean showAsAdvanced;
    public static boolean isTwelves;
    public static boolean showInfoClock;
    public static boolean showInfoRecovery;
    public static boolean showInfoStew;
    public static boolean showInfoBees;
    public static int maidWeight;
    public static int maidMin;
    public static int maidMax;
    public static int gangsterWeight;
    public static int gangsterMin;
    public static int gangsterMax;
    public static int elfWeight;
    public static int elfMin;
    public static int elfMax;
    public static int humanWeight;
    public static int humanMin;
    public static int humanMax;
    public static String defaultLitterChances;

    private static boolean validateItemName(Object obj) {
        String itemName;
        return obj instanceof String && ForgeRegistries.ITEMS.containsKey(ResourceLocation.parse((String)(itemName = (String)obj)));
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        defaultLitterChances = (String)DEFAULT_LITTER_CHANCES.get();
        maidWeight = (Integer)MAID_WEIGHT.get();
        maidMin = (Integer)MAID_MIN.get();
        maidMax = (Integer)MAID_MAX.get();
        humanWeight = (Integer)HUMAN_WEIGHT.get();
        humanMin = (Integer)HUMAN_MIN.get();
        humanMax = (Integer)HUMAN_MAX.get();
        elfWeight = (Integer)ELF_WEIGHT.get();
        elfMin = (Integer)ELF_MIN.get();
        elfMax = (Integer)ELF_MAX.get();
        gangsterWeight = (Integer)GANGSTER_WEIGHT.get();
        gangsterMin = (Integer)GANGSTER_MIN.get();
        gangsterMax = (Integer)GANGSTER_MAX.get();
        logDirtBlock = (Boolean)LOG_DIRT_BLOCK.get();
        magicNumber = (Integer)MAGIC_NUMBER.get();
        magicNumberIntroduction = (String)MAGIC_NUMBER_INTRODUCTION.get();
        showModName = (Boolean)ShowModName.get();
        showNBTLength = (Boolean)ShowNBTLength.get();
        showAsAdvanced = (Boolean)ShowAsAdvanced.get();
        isTwelves = (Boolean)IsTwelves.get();
        showInfoClock = (Boolean)ShowInfoClock.get();
        showInfoStew = (Boolean)ShowInfoStew.get();
        showInfoRecovery = (Boolean)ShowInfoRecovery.get();
        showInfoBees = (Boolean)ShowInfoBees.get();
        items = ((List)ITEM_STRINGS.get()).stream().map(itemName -> (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.parse((String)itemName))).collect(Collectors.toSet());
        allowBoth = (Boolean)AllowBoth.get();
    }
}

