/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod;

import com.yzqdev.mod.jeanmod.Config;
import com.yzqdev.mod.jeanmod.block.ModBlockEntities;
import com.yzqdev.mod.jeanmod.block.ModBlocks;
import com.yzqdev.mod.jeanmod.entity.ModEntities;
import com.yzqdev.mod.jeanmod.inventory.ModMenus;
import com.yzqdev.mod.jeanmod.item.ModItems;
import com.yzqdev.mod.jeanmod.network.NetworkHandler;
import com.yzqdev.mod.jeanmod.sound.ModSoundEvents;
import com.yzqdev.mod.jeanmod.util.ModSensorTypes;
import com.yzqdev.mod.jeanmod.villagerInventory.VillagerInventoryMod;
import com.yzqdev.mod.jeanmod.worldgen.JeanBiomeModifiers;
import com.yzqdev.mod.jeanmod.worldgen.VillageStructures;
import java.util.Locale;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="jean")
public final class JeanMod {
    public static final String MOD_ID = "jean";
    public static final Logger LOGGER = LogManager.getLogger((String)"jean");

    public JeanMod(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::commonSetup);
        ModBlocks.BLOCKS.register(modEventBus);
        ModBlockEntities.BLOCK_ENTITIES.register(modEventBus);
        ModEntities.register(modEventBus);
        ModMenus.REGISTRY.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)new VillagerInventoryMod());
        MinecraftForge.EVENT_BUS.addListener(VillageStructures::addNewVillageBuilding);
        ModSensorTypes.init(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModSoundEvents.SOUNDS.register(modEventBus);
        JeanBiomeModifiers.BIOME_MODIFIER_SERIALIZERS.register(modEventBus);
        ModItems.CREATIVE_MODE_TABS.register(modEventBus);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> event.enqueueWork(NetworkHandler::init));
    }

    public static ResourceLocation res(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)name);
    }

    public static ResourceLocation prefix(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)name.toLowerCase(Locale.ROOT));
    }
}

