/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.yzqdev.mod.jeanmod.util.ItemUtil;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class CommandJeanChest {
    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        LiteralArgumentBuilder chest = Commands.m_82127_((String)"chest");
        chest.executes(context -> CommandJeanChest.moveItemsToChest(((CommandSourceStack)context.getSource()).m_81375_()));
        chest.then(Commands.m_82127_((String)"drop").executes(context -> CommandJeanChest.dropPlayerItems(((CommandSourceStack)context.getSource()).m_81375_())));
        chest.then(Commands.m_82127_((String)"in").executes(context -> CommandJeanChest.transferItemsToContainer(((CommandSourceStack)context.getSource()).m_81375_())));
        return chest;
    }

    private static int dropPlayerItems(ServerPlayer player) {
        player.m_150109_().f_35974_.forEach(i -> ItemUtil.dropItemRandom(player.m_9236_(), i, (LivingEntity)player));
        return 1;
    }

    private static int moveItemsToChest(ServerPlayer player) {
        Direction playerFacing = player.m_6350_();
        Direction face = player.m_6350_();
        BlockPos playerPos = player.m_20183_();
        BlockPos leftPos = playerPos.m_121945_(face);
        Level level = player.m_9236_();
        if (level.m_46859_(leftPos)) {
            BlockPos rightPos = leftPos.m_121945_(face.m_122427_());
            if (!level.m_8055_(leftPos).m_247087_() || !level.m_8055_(rightPos).m_247087_()) {
                return 0;
            }
            level.m_7731_(leftPos, (BlockState)((BlockState)Blocks.f_50087_.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)face)).m_61124_((Property)ChestBlock.f_51479_, (Comparable)ChestType.LEFT), 3);
            level.m_7731_(rightPos, (BlockState)((BlockState)Blocks.f_50087_.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)face)).m_61124_((Property)ChestBlock.f_51479_, (Comparable)ChestType.RIGHT), 3);
            BlockEntity blockEntity = level.m_7702_(leftPos);
            if (blockEntity == null) {
                player.m_240418_((Component)Component.m_237113_((String)"\u76ee\u6807\u65b9\u5757\u4e0d\u662f\u5bb9\u5668\uff01"), false);
                return 0;
            }
            LazyOptional containerCap = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER);
            if (!containerCap.isPresent()) {
                player.m_240418_((Component)Component.m_237113_((String)"\u76ee\u6807\u65b9\u5757\u4e0d\u662f\u5bb9\u5668\uff01"), false);
                return 0;
            }
            IItemHandler containerHandler = (IItemHandler)containerCap.resolve().get();
            if (containerHandler != null) {
                Inventory playerInventory = player.m_150109_();
                int transferred = 0;
                for (int slot = 0; slot < playerInventory.m_6643_(); ++slot) {
                    ItemStack remaining;
                    ItemStack stack = playerInventory.m_8020_(slot);
                    if (stack.m_41619_() || (remaining = ItemUtil.transferItem(stack.m_41777_(), containerHandler)).m_41613_() >= stack.m_41613_()) continue;
                    transferred += stack.m_41613_() - remaining.m_41613_();
                    playerInventory.m_6836_(slot, remaining);
                }
                if (transferred > 0) {
                    player.m_240418_((Component)Component.m_237113_((String)("\u6210\u529f\u8f6c\u79fb\u4e86 " + transferred + " \u4e2a\u7269\u54c1\uff01")), false);
                } else {
                    player.m_240418_((Component)Component.m_237113_((String)"\u6ca1\u6709\u7269\u54c1\u53ef\u8f6c\u79fb\u6216\u5bb9\u5668\u5df2\u6ee1\uff01"), false);
                }
            }
        }
        return 0;
    }

    private static int transferItemsToContainer(ServerPlayer player) {
        BlockHitResult hitResult = CommandJeanChest.getTargetBlock(player, 5.0);
        if (hitResult.m_6662_() != HitResult.Type.BLOCK) {
            player.m_240418_((Component)Component.m_237113_((String)"\u8bf7\u5bf9\u51c6\u4e00\u4e2a\u5bb9\u5668\u65b9\u5757\uff01"), false);
            return 0;
        }
        BlockPos pos = hitResult.m_82425_();
        Level level = player.m_9236_();
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity == null) {
            player.m_240418_((Component)Component.m_237113_((String)"\u76ee\u6807\u65b9\u5757\u4e0d\u662f\u5bb9\u5668\uff01"), false);
            return 0;
        }
        LazyOptional containerCap = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER);
        if (!containerCap.isPresent()) {
            player.m_240418_((Component)Component.m_237113_((String)"\u76ee\u6807\u65b9\u5757\u4e0d\u662f\u5bb9\u5668\uff01"), false);
            return 0;
        }
        IItemHandler containerHandler = (IItemHandler)containerCap.resolve().get();
        Inventory playerInventory = player.m_150109_();
        int transferred = 0;
        for (int slot = 0; slot < playerInventory.m_6643_(); ++slot) {
            ItemStack remaining;
            ItemStack stack = playerInventory.m_8020_(slot);
            if (stack.m_41619_() || (remaining = CommandJeanChest.transferItem(stack.m_41777_(), containerHandler)).m_41613_() >= stack.m_41613_()) continue;
            transferred += stack.m_41613_() - remaining.m_41613_();
            playerInventory.m_6836_(slot, remaining);
        }
        if (transferred > 0) {
            player.m_240418_((Component)Component.m_237113_((String)("\u6210\u529f\u8f6c\u79fb\u4e86 " + transferred + " \u4e2a\u7269\u54c1\uff01")), false);
        } else {
            player.m_240418_((Component)Component.m_237113_((String)"\u6ca1\u6709\u7269\u54c1\u53ef\u8f6c\u79fb\u6216\u5bb9\u5668\u5df2\u6ee1\uff01"), false);
        }
        return 1;
    }

    private static ItemStack transferItem(ItemStack stack, IItemHandler handler) {
        ItemStack remaining = stack.m_41777_();
        for (int slot = 0; slot < handler.getSlots() && !(remaining = handler.insertItem(slot, remaining, false)).m_41619_(); ++slot) {
        }
        return remaining;
    }

    public static BlockHitResult getTargetBlock(ServerPlayer player, double maxDistance) {
        Vec3 start = player.m_20299_(1.0f);
        Vec3 look = player.m_20252_(1.0f);
        Vec3 end = start.m_82520_(look.f_82479_ * maxDistance, look.f_82480_ * maxDistance, look.f_82481_ * maxDistance);
        ClipContext context = new ClipContext(start, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player);
        return player.m_9236_().m_45547_(context);
    }
}

