/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.command;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class SummonCommand {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.summon.failed"));
    private static final SimpleCommandExceptionType ERROR_DUPLICATE_UUID = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.summon.failed.uuid"));
    private static final SimpleCommandExceptionType INVALID_POSITION = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.summon.invalidPosition"));

    public static LiteralArgumentBuilder<CommandSourceStack> get(CommandBuildContext context) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"summon").requires(p_138819_ -> p_138819_.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"entity", (ArgumentType)ResourceArgument.m_247102_((CommandBuildContext)context, (ResourceKey)Registries.f_256939_)).suggests(SuggestionProviders.f_121645_).executes(p_248175_ -> SummonCommand.spawnEntity((CommandSourceStack)p_248175_.getSource(), ResourceArgument.m_247713_((CommandContext)p_248175_, (String)"entity"), 50, new CompoundTag(), true))).then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer()).executes(cmd -> SummonCommand.spawnEntity((CommandSourceStack)cmd.getSource(), ResourceArgument.m_247713_((CommandContext)cmd, (String)"entity"), IntegerArgumentType.getInteger((CommandContext)cmd, (String)"count"), new CompoundTag(), true))));
    }

    public static Entity createEntity(CommandSourceStack source, Holder.Reference<EntityType<?>> type, Vec3 pos, CompoundTag tag, boolean randomizeProperties) throws CommandSyntaxException {
        BlockPos blockpos = BlockPos.m_274446_((Position)pos);
        if (!Level.m_46741_((BlockPos)blockpos)) {
            throw INVALID_POSITION.create();
        }
        CompoundTag compoundtag = tag.m_6426_();
        compoundtag.m_128359_("id", type.m_205785_().m_135782_().toString());
        ServerLevel serverlevel = source.m_81372_();
        Entity entity = EntityType.m_20645_((CompoundTag)compoundtag, (Level)serverlevel, p_138828_ -> {
            p_138828_.m_7678_(pos.f_82479_, pos.f_82480_, pos.f_82481_, p_138828_.m_146908_(), p_138828_.m_146909_());
            return p_138828_;
        });
        if (entity == null) {
            throw ERROR_FAILED.create();
        }
        if (randomizeProperties && entity instanceof Mob) {
            Mob mob = (Mob)entity;
            ForgeEventFactory.onFinalizeSpawn((Mob)mob, (ServerLevelAccessor)source.m_81372_(), (DifficultyInstance)source.m_81372_().m_6436_(entity.m_20183_()), (MobSpawnType)MobSpawnType.COMMAND, null, (CompoundTag)new CompoundTag());
        }
        if (!serverlevel.m_8860_(entity)) {
            throw ERROR_DUPLICATE_UUID.create();
        }
        return entity;
    }

    private static int spawnEntity(CommandSourceStack source, Holder.Reference<EntityType<?>> type, int count, CompoundTag tag, boolean randomizeProperties) {
        ServerPlayer player = source.m_230896_();
        Level level = player.m_9236_();
        Vec3 pos = player.m_146892_();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("summon-animal-pool-%d").build();
        ThreadPoolExecutor thread = new ThreadPoolExecutor(4, 8, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1000), namedThreadFactory);
        for (int i = 0; i < count; ++i) {
            thread.execute(() -> {
                double x = player.m_20185_() + (random.nextDouble() - 0.5) * 5.0;
                double z = player.m_20189_() + (random.nextDouble() - 0.5) * 5.0;
                double y = player.m_20186_();
                level.m_7654_().execute(() -> {
                    try {
                        SummonCommand.createEntity(source, type, new Vec3(x, y, z), tag, randomizeProperties);
                    }
                    catch (CommandSyntaxException e) {
                        e.printStackTrace();
                    }
                });
            });
        }
        thread.shutdown();
        Entity entity = ((EntityType)type.m_203334_()).m_20615_(player.m_9236_());
        source.m_288197_(() -> Component.m_237110_((String)"commands.summon.success", (Object[])new Object[]{entity == null ? "" : entity.m_5446_()}), true);
        return 1;
    }
}

