/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.entity.elf;

import com.yzqdev.mod.jeanmod.JeanMod;
import com.yzqdev.mod.jeanmod.entity.elf.FairyAttackGoal;
import com.yzqdev.mod.jeanmod.entity.elf.FairyType;
import com.yzqdev.mod.jeanmod.entity.elf.projectile.DanmakuShoot;
import com.yzqdev.mod.jeanmod.item.ModTags;
import com.yzqdev.mod.jeanmod.sound.ModSoundEvents;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EntityElf
extends TamableAnimal
implements RangedAttackMob,
FlyingAnimal,
GeoEntity {
    private static final int MAX_FLY_HEIGHT = 150;
    private static final String FAIRY_TYPE_TAG_NAME = "FairyType";
    private static final EntityDataAccessor<Integer> FAIRY_TYPE = SynchedEntityData.m_135353_(EntityElf.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final double AIMED_SHOT_PROBABILITY = 0.9;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public EntityElf(EntityType<? extends TamableAnimal> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 15, true);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(ModTags.maidFood);
    }

    public static AttributeSupplier.Builder createFairyAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22284_, 1.0).m_22268_(Attributes.f_22280_, 0.6);
    }

    public static boolean checkFairySpawnRules(EntityType<EntityElf> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource randomSource) {
        return true;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 20.0f, 2.0f, true));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42410_)}), false));
        this.f_21345_.m_25352_(2, (Goal)new FairyAttackGoal(this, 16.0, 2.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(2, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.5));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, false));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
    }

    public boolean m_6779_(LivingEntity pTarget) {
        TamableAnimal tamableAnimal;
        if (pTarget instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)pTarget).m_21805_() != null) {
            return false;
        }
        return super.m_6779_(pTarget);
    }

    @NotNull
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.f_19853_.f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)player) || this.m_21824_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_6898_(itemstack) && !this.m_21824_()) {
            if (itemstack.m_204117_(ModTags.maidFood)) {
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                if (this.f_19796_.m_188503_(3) == 0) {
                    this.m_21828_(player);
                    double newMaxHealth = 60.0;
                    this.m_21051_(Attributes.f_22276_).m_22100_(newMaxHealth);
                    this.m_21153_(this.m_21233_());
                    this.m_21837_(true);
                    this.m_6710_(null);
                    this.f_19853_.m_7605_((Entity)this, (byte)7);
                } else {
                    this.f_19853_.m_7605_((Entity)this, (byte)6);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (this.m_21824_() && this.m_21830_((LivingEntity)player)) {
            if (itemstack.m_204117_(ModTags.maidFood)) {
                if (!this.m_21824_() || !this.m_21830_((LivingEntity)player)) {
                    return super.m_6071_(player, hand);
                }
                this.m_5634_(4.0f);
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.f_19853_.m_7605_((Entity)this, (byte)10);
                return InteractionResult.SUCCESS;
            }
            InteractionResult interactionresult = super.m_6071_(player, hand);
            if (!interactionresult.m_19077_() && this.m_21830_((LivingEntity)player)) {
                this.m_21837_(!this.m_21825_());
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(player, hand);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_19797_ % 20 == 0) {
            if (!this.isInCombat()) {
                if (!this.m_9236_().f_46443_ && this.m_6084_() && this.m_21824_()) {
                    this.m_5634_(1.0f);
                }
            } else if (!this.m_9236_().f_46443_ && this.m_6084_() && this.m_21824_()) {
                this.m_5634_(2.0f);
            }
        }
    }

    private boolean isInCombat() {
        LivingEntity target = this.m_5448_();
        return target != null && target.m_6084_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FAIRY_TYPE, (Object)FairyType.BLACK.ordinal());
    }

    protected void m_6153_() {
        super.m_6153_();
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        float damageBase = 1.0f;
        Difficulty difficulty = target.f_19853_.m_46791_();
        switch (difficulty) {
            case NORMAL: {
                damageBase = 1.5f;
                break;
            }
            case HARD: {
                damageBase = 2.0f;
            }
        }
        List nearbyEntities = this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(16.0), e -> e instanceof LivingEntity);
        int monsterCount = nearbyEntities.size();
        if (monsterCount <= 4) {
            DanmakuShoot.create().setWorld(this.f_19853_).setThrower((LivingEntity)this).setTarget(target).setRandomColor().setRandomType().setDamage(distanceFactor + damageBase).setGravity(0.0f).setVelocity(0.5f * (distanceFactor + 1.0f)).setInaccuracy(0.2f).setFanNum(1).fanShapedShot();
        } else if (monsterCount <= 16) {
            DanmakuShoot.create().setWorld(this.f_19853_).setThrower((LivingEntity)this).setTarget(target).setRandomColor().setRandomType().setDamage(distanceFactor + damageBase + 0.5f).setGravity(0.0f).setVelocity(0.5f * (distanceFactor + 1.0f)).setInaccuracy(0.2f).setFanNum(5).setYawTotal(0.5235987755982988).fanShapedShot();
        } else {
            DanmakuShoot.create().setWorld(this.f_19853_).setThrower((LivingEntity)this).setTarget(target).setRandomColor().setRandomType().setDamage(distanceFactor + damageBase + 0.5f).setGravity(0.0f).setVelocity(0.5f * (distanceFactor + 1.0f)).setInaccuracy(0.2f).setFanNum(9).setYawTotal(0.5235987755982988).fanShapedShot();
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (super.m_6469_(source, amount) && !(source.m_7639_() instanceof Player)) {
            if (this.m_21824_()) {
                this.m_21837_(false);
                if (this.m_20186_() > 150.0) {
                    this.m_20334_(this.m_20184_().f_82479_, 0.0, this.m_20184_().f_82481_);
                }
                this.m_20334_(this.m_20184_().f_82479_, 3.0, this.m_20184_().f_82481_);
                JeanMod.LOGGER.info("movemovemove");
            }
            return true;
        }
        return false;
    }

    protected PathNavigation m_6037_(Level worldIn) {
        FlyingPathNavigation navigator = new FlyingPathNavigation((Mob)this, worldIn);
        navigator.m_26440_(false);
        navigator.m_7008_(true);
        navigator.m_26443_(true);
        return navigator;
    }

    @javax.annotation.Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @javax.annotation.Nullable SpawnGroupData spawnDataIn, @javax.annotation.Nullable CompoundTag dataTag) {
        this.setFairyTypeOrdinal(this.f_19796_.m_188503_(FairyType.values().length));
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_(FAIRY_TYPE_TAG_NAME, this.getFairyTypeOrdinal());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_(FAIRY_TYPE_TAG_NAME, 3)) {
            this.setFairyTypeOrdinal(compound.m_128451_(FAIRY_TYPE_TAG_NAME));
        }
    }

    public int getFairyTypeOrdinal() {
        return (Integer)this.f_19804_.m_135370_(FAIRY_TYPE);
    }

    public void setFairyTypeOrdinal(int ordinal) {
        this.f_19804_.m_135381_(FAIRY_TYPE, (Object)ordinal);
    }

    public boolean m_29443_() {
        return !this.m_20096_();
    }

    public void m_21837_(boolean inSittingPose) {
        super.m_21837_(inSittingPose);
        this.m_21839_(inSittingPose);
    }

    @javax.annotation.Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.FAIRY_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSoundEvents.FAIRY_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.FAIRY_DEATH.get();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "sit", 0, state -> ((EntityElf)state.getAnimatable()).m_21825_() ? state.setAndContinue(DefaultAnimations.SIT) : PlayState.STOP)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 0, this::attackPredicate)});
    }

    private PlayState predicate(AnimationState animationState) {
        animationState.getController().setAnimation(RawAnimation.begin().then("misc.idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    private PlayState attackPredicate(AnimationState state) {
        if (this.f_20911_ && state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            state.getController().forceAnimationReset();
            state.getController().setAnimation(RawAnimation.begin().then("attack.strike", Animation.LoopType.PLAY_ONCE));
            this.f_20911_ = false;
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

