/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.entity.elf.elf;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.yzqdev.mod.jeanmod.entity.elf.projectile.DanmakuColor;
import com.yzqdev.mod.jeanmod.entity.elf.projectile.DanmakuType;
import com.yzqdev.mod.jeanmod.entity.elf.projectile.EntityDanmaku;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class EntityDanmakuRenderer
extends EntityRenderer<EntityDanmaku> {
    private static final ResourceLocation DANMAKU_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jean", (String)"textures/entity/danmaku.png");
    private static final RenderType RENDER_TYPE = RenderType.m_110467_((ResourceLocation)DANMAKU_TEXTURE);

    public EntityDanmakuRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    private static void vertex(VertexConsumer bufferIn, Matrix4f pose, Matrix3f normal, double x, double y, double texU, double texV, int packedLight) {
        bufferIn.m_252986_(pose, (float)x, (float)y, 0.0f).m_6122_(255, 255, 255, 255).m_7421_((float)texU, (float)texV).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public void render(EntityDanmaku entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        DanmakuColor color = entity.getColor();
        DanmakuType type = entity.getDanmakuType();
        int width = 416;
        int length = 128;
        double startU = 32 * color.ordinal();
        double startV = 32 * type.ordinal();
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.1, 0.0);
        poseStack.m_252781_(this.f_114476_.m_253208_());
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        VertexConsumer buffer = bufferIn.m_6299_(RENDER_TYPE);
        PoseStack.Pose poseStackLast = poseStack.m_85850_();
        Matrix4f pose = poseStackLast.m_252922_();
        Matrix3f normal = poseStackLast.m_252943_();
        EntityDanmakuRenderer.vertex(buffer, pose, normal, -type.getSize(), type.getSize(), (startU + 0.0) / (double)width, (startV + 0.0) / (double)length, packedLightIn);
        EntityDanmakuRenderer.vertex(buffer, pose, normal, -type.getSize(), -type.getSize(), (startU + 0.0) / (double)width, (startV + 32.0) / (double)length, packedLightIn);
        EntityDanmakuRenderer.vertex(buffer, pose, normal, type.getSize(), -type.getSize(), (startU + 32.0) / (double)width, (startV + 32.0) / (double)length, packedLightIn);
        EntityDanmakuRenderer.vertex(buffer, pose, normal, type.getSize(), type.getSize(), (startU + 32.0) / (double)width, (startV + 0.0) / (double)length, packedLightIn);
        poseStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(EntityDanmaku entity) {
        return DANMAKU_TEXTURE;
    }
}

