/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.entity.gangster;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import com.yzqdev.mod.jeanmod.entity.ModEntities;
import com.yzqdev.mod.jeanmod.entity.gangster.GangsterAi;
import com.yzqdev.mod.jeanmod.entity.gangster.GangsterHit;
import com.yzqdev.mod.jeanmod.util.ItemUtil;
import com.yzqdev.mod.jeanmod.util.ModSensorTypes;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Gangster
extends Animal
implements Enemy,
GangsterHit,
GeoEntity,
InventoryCarrier {
    private static final EntityDataAccessor<Boolean> DATA_IMMUNE_TO_ZOMBIFICATION = SynchedEntityData.m_135353_(Gangster.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int attackAnimationRemainingTicks;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super Gangster>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26814_, (Object)SensorType.f_26811_, (Object)SensorType.f_26810_, (Object)((SensorType)ModSensorTypes.GANGSTER_PICKUP_ENTITIES_SENSOR_SENSOR_TYPE.get()), (Object)SensorType.f_26812_, (Object)SensorType.f_26822_);
    protected static final ImmutableList<? extends MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26375_, (Object)MemoryModuleType.f_148204_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26368_, (Object)MemoryModuleType.f_148206_, (Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_26372_, (Object)MemoryModuleType.f_26373_, (Object)MemoryModuleType.f_26350_, (Object[])new MemoryModuleType[]{MemoryModuleType.f_26383_, MemoryModuleType.f_26352_, MemoryModuleType.f_26353_, MemoryModuleType.f_26348_, MemoryModuleType.f_26331_, MemoryModuleType.f_26356_, (MemoryModuleType)ModSensorTypes.VISIBLE_PICKUP_ENTITIES.get(), MemoryModuleType.f_26357_});
    private final SimpleContainer inventory = new SimpleContainer(21);

    public Gangster(String name, Level level) {
        this((EntityType<? extends Gangster>)((EntityType)ModEntities.GANGSTER.get()), level);
    }

    public Gangster(EntityType<? extends Gangster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 5;
    }

    public boolean m_6573_(Player pPlayer) {
        return !this.m_21523_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22278_, (double)0.6f).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22281_, 6.0);
    }

    public boolean m_7327_(Entity pEntity) {
        if (!(pEntity instanceof LivingEntity)) {
            return false;
        }
        this.attackAnimationRemainingTicks = 10;
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        this.m_5496_(SoundEvents.f_11958_, 1.0f, this.m_6100_());
        GangsterAi.onHitTarget(this, (LivingEntity)pEntity);
        return GangsterHit.hurtAndThrowTarget((LivingEntity)this, (LivingEntity)pEntity);
    }

    protected void m_6731_(LivingEntity pEntity) {
        if (this.isAdult()) {
            GangsterHit.throwTarget((LivingEntity)this, pEntity);
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        this.triggerAnim("attacked_controller", "attacked");
        boolean flag = super.m_6469_(pSource, pAmount);
        if (this.m_9236_().f_46443_) {
            return false;
        }
        if (flag && pSource.m_7639_() instanceof LivingEntity) {
            GangsterAi.wasHurtBy(this, (LivingEntity)pSource.m_7639_());
        }
        return flag;
    }

    protected Brain.Provider<Gangster> m_5490_() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> m_8075_(Dynamic<?> pDynamic) {
        return GangsterAi.makeBrain((Brain<Gangster>)this.m_5490_().m_22073_(pDynamic));
    }

    public Brain<Gangster> m_6274_() {
        return super.m_6274_();
    }

    protected void m_8024_() {
        this.m_9236_().m_46473_().m_6180_("gangsterBrain");
        this.m_6274_().m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        this.m_9236_().m_46473_().m_7238_();
        GangsterAi.updateActivity(this);
    }

    public void m_8107_() {
        if (this.attackAnimationRemainingTicks > 0) {
            --this.attackAnimationRemainingTicks;
        }
        super.m_8107_();
    }

    protected void m_30232_() {
        if (this.m_6162_()) {
            this.f_21364_ = 3;
            this.m_21051_(Attributes.f_22281_).m_22100_(3.5);
        } else {
            this.f_21364_ = 5;
            this.m_21051_(Attributes.f_22281_).m_22100_(6.0);
        }
    }

    protected void m_5907_() {
        super.m_5907_();
        BlockPos pos = this.m_20183_();
        Level world = this.m_9236_();
        if (world.m_46859_(pos)) {
            world.m_46597_(pos, Blocks.f_50087_.m_49966_());
            BlockEntity blockEntity = this.f_19853_.m_7702_(pos);
            LazyOptional containerCap = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER);
            if (containerCap.isPresent()) {
                IItemHandler containerHandler = (IItemHandler)containerCap.resolve().get();
                this.m_6167_().forEach(i -> ItemUtil.transferItem(i, containerHandler));
                this.inventory.f_19147_.forEach(i -> ItemUtil.transferItem(i, containerHandler));
            }
        } else {
            this.m_6167_().forEach(i -> ItemUtil.dropItem(this.m_9236_(), i, (LivingEntity)this));
            this.inventory.f_19147_.forEach(i -> ItemUtil.dropItem(this.m_9236_(), i, (LivingEntity)this));
        }
    }

    public SimpleContainer m_35311_() {
        return this.inventory;
    }

    protected void m_6138_() {
        super.m_6138_();
        List entityList = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82377_(0.5, 0.0, 0.5), i -> true);
        if (!entityList.isEmpty() && this.m_6084_()) {
            for (Entity entity : entityList) {
                if (!(entity instanceof ItemEntity)) continue;
                ItemEntity itemEntity = (ItemEntity)entity;
                this.pickupItem(itemEntity, false);
            }
        }
    }

    public boolean pickupItem(ItemEntity entityItem, boolean simulate) {
        if (!this.m_9236_().f_46443_ && entityItem.m_6084_() && !entityItem.m_32063_()) {
            ItemStack itemstack = entityItem.m_32055_();
            int count = itemstack.m_41613_();
            if (count == (itemstack = this.inventory.m_19173_(itemstack)).m_41613_()) {
                return false;
            }
            if (!simulate) {
                this.m_7938_((Entity)entityItem, count - itemstack.m_41613_());
                if (itemstack.m_41619_()) {
                    entityItem.m_146870_();
                } else {
                    entityItem.m_32045_(itemstack);
                }
            }
            return true;
        }
        return false;
    }

    public static boolean checkHoglinSpawnRules(EntityType<Gangster> pHoglin, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return !pLevel.m_8055_(pPos.m_7495_()).m_60713_(Blocks.f_50451_);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return !this.m_21532_();
    }

    public float m_5610_(BlockPos pPos, LevelReader pLevel) {
        if (GangsterAi.isPosNearNearestRepellent(this, pPos)) {
            return -1.0f;
        }
        return pLevel.m_8055_(pPos.m_7495_()).m_60713_(Blocks.f_50699_) ? 10.0f : 0.0f;
    }

    public double m_6048_() {
        return (double)this.m_20206_() - (this.m_6162_() ? 0.2 : 0.15);
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        InteractionResult interactionresult = super.m_6071_(pPlayer, pHand);
        ItemStack item = pPlayer.m_21205_();
        if (interactionresult.m_19077_()) {
            this.m_21530_();
        }
        return interactionresult;
    }

    public void m_7822_(byte pId) {
        if (pId == 4) {
            this.attackAnimationRemainingTicks = 10;
            this.m_5496_(SoundEvents.f_11958_, 1.0f, this.m_6100_());
        } else {
            super.m_7822_(pId);
        }
    }

    @Override
    public int getAttackAnimationRemainingTicks() {
        return this.attackAnimationRemainingTicks;
    }

    public boolean m_6149_() {
        return true;
    }

    public int m_213860_() {
        return this.f_21364_;
    }

    public boolean m_6898_(ItemStack pStack) {
        return pStack.m_150930_(Items.f_41954_);
    }

    public boolean isAdult() {
        return !this.m_6162_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IMMUNE_TO_ZOMBIFICATION, (Object)false);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.m_253224_(compound);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.m_252802_(compound);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    public boolean m_5957_() {
        return !GangsterAi.isPacified(this) && super.m_5957_();
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    protected SoundEvent m_7515_() {
        return this.m_9236_().f_46443_ ? null : GangsterAi.getSoundForCurrentActivity(this).orElse(null);
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_11961_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11960_;
    }

    protected SoundEvent m_5501_() {
        return SoundEvents.f_12042_;
    }

    protected SoundEvent m_5509_() {
        return SoundEvents.f_12041_;
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_(SoundEvents.f_11963_, 0.15f, 1.0f);
    }

    protected void playSoundEvent(SoundEvent pSoundEvent) {
        this.m_5496_(pSoundEvent, this.m_6121_(), this.m_6100_());
    }

    protected void m_8025_() {
        super.m_8025_();
        DebugPackets.m_133695_((LivingEntity)this);
    }

    private PlayState predicate(AnimationState animationState) {
        if (animationState.isMoving()) {
            animationState.getController().setAnimation(RawAnimation.begin().then("move.walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        animationState.getController().setAnimation(RawAnimation.begin().then("misc.idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    private PlayState attackPredicate(AnimationState state) {
        if (this.f_20911_ && state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            state.getController().forceAnimationReset();
            state.getController().setAnimation(RawAnimation.begin().then("attack.strike", Animation.LoopType.PLAY_ONCE));
            this.f_20911_ = false;
        }
        return PlayState.CONTINUE;
    }

    private PlayState diePredicate(AnimationState state) {
        if (this.m_21224_()) {
            return state.setAndContinue(DefaultAnimations.DIE);
        }
        state.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    private PlayState jumpPredicate(AnimationState state) {
        if (this.m_20069_() || this.m_20096_() || this.m_20159_() || this.f_20916_ > 0) {
            return PlayState.STOP;
        }
        state.getController().setAnimation(RawAnimation.begin().then("jump", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 0, this::attackPredicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "jumpController", 0, this::jumpPredicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attacked_controller", event -> PlayState.STOP).triggerableAnim("attacked", RawAnimation.begin().then("attacked", Animation.LoopType.PLAY_ONCE))});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "die", 0, this::diePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static boolean checkGangsterSpawnRules(EntityType<Gangster> gangsterEntityType, ServerLevelAccessor serverLevelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        return true;
    }

    public static boolean canSpawn(EntityType<Gangster> gangsterEntityType, ServerLevelAccessor serverLevelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        return true;
    }
}

