/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.entity.gangster;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.yzqdev.mod.jeanmod.entity.gangster.Gangster;
import com.yzqdev.mod.jeanmod.entity.gangster.GangsterPickupEntitiesTask;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.BecomePassiveIfMemoryPresent;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.schedule.Activity;

public class GangsterAi {
    public static final int REPELLENT_DETECTION_RANGE_HORIZONTAL = 8;
    public static final int REPELLENT_DETECTION_RANGE_VERTICAL = 4;
    private static final UniformInt RETREAT_DURATION = TimeUtil.m_145020_((int)5, (int)20);
    private static final int ATTACK_DURATION = 200;
    private static final int DESIRED_DISTANCE_FROM_PIGLIN_WHEN_IDLING = 8;
    private static final int DESIRED_DISTANCE_FROM_PIGLIN_WHEN_RETREATING = 15;
    private static final int ATTACK_INTERVAL = 40;
    private static final int BABY_ATTACK_INTERVAL = 15;
    private static final int REPELLENT_PACIFY_TIME = 200;
    private static final UniformInt ADULT_FOLLOW_RANGE = UniformInt.m_146622_((int)5, (int)16);
    private static final float SPEED_MULTIPLIER_WHEN_AVOIDING_REPELLENT = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_RETREATING = 1.3f;
    private static final float SPEED_MULTIPLIER_WHEN_MAKING_LOVE = 0.6f;
    private static final float SPEED_MULTIPLIER_WHEN_IDLING = 0.4f;
    private static final float SPEED_MULTIPLIER_WHEN_FOLLOWING_ADULT = 0.6f;

    protected static Brain<?> makeBrain(Brain<Gangster> pBrain) {
        GangsterAi.initCoreActivity(pBrain);
        GangsterAi.initIdleActivity(pBrain);
        GangsterAi.initFightActivity(pBrain);
        GangsterAi.initRetreatActivity(pBrain);
        pBrain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        pBrain.m_21944_(Activity.f_37979_);
        pBrain.m_21962_();
        return pBrain;
    }

    private static void initCoreActivity(Brain<Gangster> pBrain) {
        pBrain.m_21900_(Activity.f_37978_, ImmutableList.of((Object)Pair.of((Object)0, (Object)new Swim(0.8f)), (Object)Pair.of((Object)4, (Object)((Object)new GangsterPickupEntitiesTask(1.2f))), (Object)Pair.of((Object)1, (Object)new LookAtTargetSink(45, 90)), (Object)Pair.of((Object)2, (Object)new MoveToTargetSink())));
    }

    private static void initIdleActivity(Brain<Gangster> pBrain) {
        pBrain.m_21900_(Activity.f_37979_, ImmutableList.of((Object)Pair.of((Object)1, (Object)BecomePassiveIfMemoryPresent.m_257393_((MemoryModuleType)MemoryModuleType.f_26356_, (int)200)), (Object)Pair.of((Object)2, (Object)GangsterAi.randomStroll()), (Object)Pair.of((Object)3, (Object)SetWalkTargetAwayFrom.m_257620_((MemoryModuleType)MemoryModuleType.f_26356_, (float)1.0f, (int)8, (boolean)true)), (Object)Pair.of((Object)5, (Object)StartAttacking.m_257710_(GangsterAi::findNearestValidAttackTarget)), (Object)Pair.of((Object)6, (Object)SetEntityLookTargetSometimes.m_257458_((float)8.0f, (UniformInt)UniformInt.m_146622_((int)30, (int)60))), (Object)Pair.of((Object)7, (Object)BabyFollowAdult.m_257685_((UniformInt)ADULT_FOLLOW_RANGE, (float)0.6f))));
    }

    private static void initFightActivity(Brain<Gangster> pBrain) {
        pBrain.m_21907_(Activity.f_37988_, ImmutableList.of((Object)Pair.of((Object)1, (Object)BecomePassiveIfMemoryPresent.m_257393_((MemoryModuleType)MemoryModuleType.f_26356_, (int)200)), (Object)Pair.of((Object)1, (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.m_257469_((float)1.0f)), (Object)Pair.of((Object)1, (Object)BehaviorBuilder.m_257845_(Gangster::isAdult, (OneShot)MeleeAttack.m_257733_((int)40))), (Object)Pair.of((Object)1, (Object)BehaviorBuilder.m_257845_(AgeableMob::m_6162_, (OneShot)MeleeAttack.m_257733_((int)15))), (Object)Pair.of((Object)1, (Object)StopAttackingIfTargetInvalid.m_257822_()), (Object)Pair.of((Object)1, (Object)EraseMemoryIf.m_258093_(GangsterAi::isBreeding, (MemoryModuleType)MemoryModuleType.f_26372_))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT)), (Set)ImmutableSet.of((Object)MemoryModuleType.f_26372_));
    }

    private static void initRetreatActivity(Brain<Gangster> pBrain) {
        pBrain.m_21895_(Activity.f_37991_, 10, ImmutableList.of((Object)SetWalkTargetAwayFrom.m_257370_((MemoryModuleType)MemoryModuleType.f_26383_, (float)1.3f, (int)15, (boolean)false), (Object)SetEntityLookTargetSometimes.m_257458_((float)8.0f, (UniformInt)UniformInt.m_146622_((int)30, (int)60)), (Object)EraseMemoryIf.m_258093_(GangsterAi::wantsToStopFleeing, (MemoryModuleType)MemoryModuleType.f_26383_)), MemoryModuleType.f_26383_);
    }

    private static RunOne<Gangster> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.m_257965_((float)0.4f), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.m_257764_((float)0.4f, (int)3), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    protected static void updateActivity(Gangster pGangster) {
        Activity activity1;
        Brain<Gangster> brain = pGangster.m_6274_();
        Activity activity = brain.m_21968_().orElse(null);
        brain.m_21926_((List)ImmutableList.of((Object)Activity.f_37988_, (Object)Activity.f_37991_, (Object)Activity.f_37979_));
        if (LocalDateTime.now().getSecond() % 5 == 0) {
            // empty if block
        }
        if (activity != (activity1 = brain.m_21968_().orElse(null))) {
            GangsterAi.getSoundForCurrentActivity(pGangster).ifPresent(pGangster::playSoundEvent);
        }
        pGangster.m_21561_(brain.m_21874_(MemoryModuleType.f_26372_));
    }

    private static RunOne randomStroll() {
        Pair walkRandomly = Pair.of((Object)RandomStroll.m_257960_((float)1.0f, (int)5, (int)3), (Object)1);
        Pair noLook = Pair.of((Object)new DoNothing(30, 60), (Object)2);
        return new RunOne((List)ImmutableList.of((Object)walkRandomly, (Object)noLook));
    }

    protected static void onHitTarget(Gangster pGangster, LivingEntity pTarget) {
        if (!pGangster.m_6162_()) {
            if (pTarget.m_6095_() == EntityType.f_20511_ && GangsterAi.piglinsOutnumberHoglins(pGangster)) {
                GangsterAi.setAvoidTarget(pGangster, pTarget);
                GangsterAi.broadcastRetreat(pGangster, pTarget);
            } else {
                GangsterAi.broadcastAttackTarget(pGangster, pTarget);
            }
        }
    }

    private static void broadcastRetreat(Gangster pGangster, LivingEntity pTarget) {
        GangsterAi.retreatFromNearestTarget(pGangster, pTarget);
    }

    private static void retreatFromNearestTarget(Gangster pGangster, LivingEntity pTarget) {
        Brain<Gangster> brain = pGangster.m_6274_();
        LivingEntity $$2 = BehaviorUtils.m_22625_((LivingEntity)pGangster, (Optional)brain.m_21952_(MemoryModuleType.f_26383_), (LivingEntity)pTarget);
        $$2 = BehaviorUtils.m_22625_((LivingEntity)pGangster, (Optional)brain.m_21952_(MemoryModuleType.f_26372_), (LivingEntity)$$2);
        GangsterAi.setAvoidTarget(pGangster, $$2);
    }

    private static void setAvoidTarget(Gangster pGangster, LivingEntity pTarget) {
        pGangster.m_6274_().m_21936_(MemoryModuleType.f_26372_);
        pGangster.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        pGangster.m_6274_().m_21882_(MemoryModuleType.f_26383_, (Object)pTarget, (long)RETREAT_DURATION.m_214085_(pGangster.m_9236_().f_46441_));
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(Gangster gangster) {
        Optional living = gangster.m_6274_().m_21952_(MemoryModuleType.f_148205_);
        Optional attackable = living.flatMap(m -> m.m_186116_(v -> v.m_6084_() && !(v instanceof Creeper)));
        if (attackable.isPresent() && !(attackable.get() instanceof Gangster)) {
            return !GangsterAi.isPacified(gangster) && !GangsterAi.isBreeding(gangster) ? attackable : Optional.empty();
        }
        return Optional.empty();
    }

    static boolean isPosNearNearestRepellent(Gangster pGangster, BlockPos pPos) {
        Optional optional = pGangster.m_6274_().m_21952_(MemoryModuleType.f_26356_);
        return optional.isPresent() && ((BlockPos)optional.get()).m_123314_((Vec3i)pPos, 8.0);
    }

    private static boolean wantsToStopFleeing(Gangster p_34618_) {
        return p_34618_.isAdult() && !GangsterAi.piglinsOutnumberHoglins(p_34618_);
    }

    private static boolean piglinsOutnumberHoglins(Gangster pGangster) {
        int j;
        if (pGangster.m_6162_()) {
            return false;
        }
        int i = pGangster.m_6274_().m_21952_(MemoryModuleType.f_26352_).orElse(0);
        return i > (j = pGangster.m_6274_().m_21952_(MemoryModuleType.f_26353_).orElse(0) + 1);
    }

    protected static void wasHurtBy(Gangster pGangster, LivingEntity pLivingEntity) {
        Brain<Gangster> brain = pGangster.m_6274_();
        brain.m_21936_(MemoryModuleType.f_26357_);
        brain.m_21936_(MemoryModuleType.f_26375_);
        if (pGangster.m_6162_()) {
            GangsterAi.retreatFromNearestTarget(pGangster, pLivingEntity);
        } else {
            GangsterAi.maybeRetaliate(pGangster, pLivingEntity);
        }
    }

    private static void maybeRetaliate(Gangster pGangster, LivingEntity pLivingEntity) {
        if (!(pGangster.m_6274_().m_21954_(Activity.f_37991_) && pLivingEntity.m_6095_() == EntityType.f_20511_ || pLivingEntity.m_6095_() == EntityType.f_20456_ || BehaviorUtils.m_22598_((LivingEntity)pGangster, (LivingEntity)pLivingEntity, (double)4.0) || !Sensor.m_148312_((LivingEntity)pGangster, (LivingEntity)pLivingEntity))) {
            GangsterAi.setAttackTarget(pGangster, pLivingEntity);
            GangsterAi.broadcastAttackTarget(pGangster, pLivingEntity);
        }
    }

    private static void setAttackTarget(Gangster pGangster, LivingEntity pTarget) {
        Brain<Gangster> brain = pGangster.m_6274_();
        brain.m_21936_(MemoryModuleType.f_26326_);
        brain.m_21936_(MemoryModuleType.f_26375_);
        brain.m_21882_(MemoryModuleType.f_26372_, (Object)pTarget, 200L);
    }

    private static void broadcastAttackTarget(Gangster pGangster, LivingEntity pTarget) {
        GangsterAi.setAttackTargetIfCloserThanCurrent(pGangster, pTarget);
    }

    private static void setAttackTargetIfCloserThanCurrent(Gangster pGangster, LivingEntity pTarget) {
        if (!GangsterAi.isPacified(pGangster)) {
            Optional optional = pGangster.m_6274_().m_21952_(MemoryModuleType.f_26372_);
            LivingEntity livingentity = BehaviorUtils.m_22625_((LivingEntity)pGangster, (Optional)optional, (LivingEntity)pTarget);
            GangsterAi.setAttackTarget(pGangster, livingentity);
        }
    }

    public static Optional<SoundEvent> getSoundForCurrentActivity(Gangster pGangster) {
        return pGangster.m_6274_().m_21968_().map(p_34600_ -> GangsterAi.getSoundForActivity(pGangster, p_34600_));
    }

    private static SoundEvent getSoundForActivity(Gangster pGangster, Activity pActivity) {
        if (pActivity != Activity.f_37991_) {
            if (pActivity == Activity.f_37988_) {
                return SoundEvents.f_11957_;
            }
            return GangsterAi.isNearRepellent(pGangster) ? SoundEvents.f_11962_ : SoundEvents.f_11956_;
        }
        return SoundEvents.f_11962_;
    }

    private static boolean isNearRepellent(Gangster pGangster) {
        return pGangster.m_6274_().m_21874_(MemoryModuleType.f_26356_);
    }

    private static boolean isBreeding(Gangster p_34638_) {
        return p_34638_.m_6274_().m_21874_(MemoryModuleType.f_26375_);
    }

    protected static boolean isPacified(Gangster pGangster) {
        return pGangster.m_6274_().m_21874_(MemoryModuleType.f_26357_);
    }
}

