/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.entity.gangster;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.yzqdev.mod.jeanmod.entity.gangster.Gangster;
import com.yzqdev.mod.jeanmod.util.ModSensorTypes;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.item.ItemEntity;

public class GangsterPickupEntitiesTask
extends Behavior<Gangster> {
    private final Predicate<Gangster> predicate;
    private final float speedModifier;

    public GangsterPickupEntitiesTask(float speedModifier) {
        this((Predicate<Gangster>)Predicates.alwaysTrue(), speedModifier);
    }

    public GangsterPickupEntitiesTask(Predicate<Gangster> predicate, float speedModifier) {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)ModSensorTypes.VISIBLE_PICKUP_ENTITIES.get()), (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT));
        this.predicate = predicate;
        this.speedModifier = speedModifier;
    }

    protected boolean checkExtraStartConditions(ServerLevel worldIn, Gangster owner) {
        return this.predicate.test(owner);
    }

    protected void start(ServerLevel worldIn, Gangster gangster, long gameTimeIn) {
        this.getItems(gangster).stream().filter(e -> gangster.m_21444_(e.m_20183_()) && e instanceof ItemEntity && !e.m_20069_()).findFirst().ifPresent(e -> BehaviorUtils.m_22590_((LivingEntity)gangster, (Entity)e, (float)this.speedModifier, (int)0));
    }

    private List<Entity> getItems(Gangster maid) {
        return maid.m_6274_().m_21952_((MemoryModuleType)ModSensorTypes.VISIBLE_PICKUP_ENTITIES.get()).orElse(Lists.newArrayList());
    }
}

