/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.entity.human;

import com.mojang.serialization.Dynamic;
import com.yzqdev.mod.jeanmod.entity.ModEntities;
import com.yzqdev.mod.jeanmod.entity.human.HumanAI;
import com.yzqdev.mod.jeanmod.network.NetworkHandler;
import com.yzqdev.mod.jeanmod.network.PlayHumanSoundMessage;
import com.yzqdev.mod.jeanmod.sound.ModSoundEvents;
import com.yzqdev.mod.jeanmod.sound.human.HumanSoundLoader;
import com.yzqdev.mod.jeanmod.util.ModSensorTypes;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Human
extends TamableAnimal
implements GeoEntity {
    protected static final List<SensorType<? extends Sensor<? super Human>>> SENSOR_TYPES = List.of(SensorType.f_26811_, SensorType.f_26812_, SensorType.f_26810_, (SensorType)ModSensorTypes.HUMAN_TEMPTATIONS.get(), SensorType.f_26814_);
    protected static final List<MemoryModuleType<?>> MEMORY_TYPES = List.of(MemoryModuleType.f_26371_, MemoryModuleType.f_148205_, MemoryModuleType.f_26370_, MemoryModuleType.f_26326_, MemoryModuleType.f_26333_, MemoryModuleType.f_26377_, MemoryModuleType.f_26334_, MemoryModuleType.f_26372_, MemoryModuleType.f_26373_, MemoryModuleType.f_26351_, MemoryModuleType.f_26381_, MemoryModuleType.f_26382_, MemoryModuleType.f_148206_, MemoryModuleType.f_26355_, MemoryModuleType.f_26375_, MemoryModuleType.f_148196_, MemoryModuleType.f_26331_, MemoryModuleType.f_26368_, MemoryModuleType.f_148197_, MemoryModuleType.f_148198_, MemoryModuleType.f_217768_);
    private static final EntityDataAccessor<String> DATA_SOUND_PACK_ID = SynchedEntityData.m_135353_(Human.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int lowerHeadTick;
    private int eatAnimationTick;
    private final String DataSoundPack = "sound_pack_id";
    private final int infestationCounter = 0;

    public Human(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.m_21573_().m_7008_(true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 1.5).m_22268_(Attributes.f_22284_, 1.0);
    }

    public static boolean canSpawn(EntityType<Human> type, ServerLevelAccessor accessor, MobSpawnType reason, BlockPos pos, RandomSource rand) {
        return true;
    }

    public static boolean checkHumanSpawnRules(EntityType<Human> humanEntityType, ServerLevelAccessor serverLevelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        return true;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ModSoundEvents.HUMAN_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.HUMAN_HURT.get();
    }

    public void m_5496_(SoundEvent sound, float volume, float pitch) {
        if (sound.m_11660_().m_135815_().contains("human")) {
            Level level = this.m_9236_();
            if (!level.m_5776_()) {
                NetworkHandler.sendToNearby((Entity)this, new PlayHumanSoundMessage(sound.m_11660_(), this.getSoundPackId(), this.m_19879_()), 16);
            }
        } else {
            super.m_5496_(sound, volume, pitch);
        }
    }

    public String getSoundPackId() {
        return (String)this.f_19804_.m_135370_(DATA_SOUND_PACK_ID);
    }

    public void setSoundPackId(String soundPackId) {
        this.f_19804_.m_135381_(DATA_SOUND_PACK_ID, (Object)soundPackId);
    }

    protected void m_8097_() {
        super.m_8097_();
        List<String> sounds = HumanSoundLoader.getSoundIds();
        if (!sounds.isEmpty()) {
            String id = sounds.get(this.f_19796_.m_188503_(sounds.size()));
            this.f_19804_.m_135372_(DATA_SOUND_PACK_ID, (Object)id);
        } else {
            this.f_19804_.m_135372_(DATA_SOUND_PACK_ID, (Object)"nilu");
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("sound_pack_id")) {
            this.setSoundPackId(compound.m_128461_("sound_pack_id"));
        } else {
            List<String> sounds = HumanSoundLoader.getSoundIds();
            if (!sounds.isEmpty()) {
                this.setSoundPackId(sounds.get(this.f_19796_.m_188503_(sounds.size())));
            } else {
                this.setSoundPackId("nilu");
            }
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("sound_pack_id", this.getSoundPackId());
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        boolean flag = super.m_6469_(pSource, pAmount);
        if (this.m_9236_().f_46443_) {
            return false;
        }
        if (flag && pSource.m_7639_() instanceof LivingEntity) {
            HumanAI.hurtBy(this, (LivingEntity)pSource.m_7639_());
        }
        return flag;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob otherParent) {
        return (AgeableMob)((EntityType)ModEntities.HUMAN.get()).m_20615_((Level)level);
    }

    protected void m_8025_() {
        super.m_8025_();
        DebugPackets.m_133695_((LivingEntity)this);
    }

    protected Brain.Provider<Human> m_5490_() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    @NotNull
    protected Brain<Human> m_8075_(Dynamic<?> dynamic) {
        return HumanAI.makeBrain(this, (Brain<Human>)this.m_5490_().m_22073_(dynamic));
    }

    @NotNull
    public Brain<Human> m_6274_() {
        return super.m_6274_();
    }

    protected void m_8024_() {
        Level level = this.m_9236_();
        this.m_9236_().m_46473_().m_6180_("humanBrain");
        this.m_6274_().m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        this.m_9236_().m_46473_().m_7238_();
        HumanAI.updateActivity(this);
    }

    public void m_8107_() {
        if (this.m_9236_().f_46443_) {
            this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
        }
        super.m_8107_();
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        RandomSource randomSource = level.m_213780_();
        if (!StringUtils.isBlank((CharSequence)this.getSoundPackId())) {
            this.m_6593_((Component)Component.m_237113_((String)this.getSoundPackId()));
        }
        HumanAI.initMemories(this, randomSource);
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    private PlayState predicate(AnimationState animationState) {
        if (animationState.isMoving()) {
            animationState.getController().setAnimation(RawAnimation.begin().then("move.walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        animationState.getController().setAnimation(RawAnimation.begin().then("misc.idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    private PlayState attackPredicate(AnimationState state) {
        if (this.f_20911_ && state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            state.getController().forceAnimationReset();
            state.getController().setAnimation(RawAnimation.begin().then("attack.strike", Animation.LoopType.PLAY_ONCE));
            this.f_20911_ = false;
        }
        return PlayState.CONTINUE;
    }

    public int m_8085_() {
        return 15;
    }

    public void m_5616_(float yHeadRot) {
        int i = this.m_8085_();
        float f = Mth.m_14118_((float)this.f_20883_, (float)yHeadRot);
        float g = Mth.m_14036_((float)f, (float)(-i), (float)i);
        super.m_5616_(this.f_20883_ + g);
    }

    public float getHeadEatPositionScale(float partialTick) {
        if (this.eatAnimationTick <= 0) {
            return 0.0f;
        }
        if (this.eatAnimationTick >= 4 && this.eatAnimationTick <= 36) {
            return 1.0f;
        }
        return this.eatAnimationTick < 4 ? ((float)this.eatAnimationTick - partialTick) / 4.0f : -((float)(this.eatAnimationTick - 40) - partialTick) / 4.0f;
    }

    public float getHeadEatAngleScale(float partialTick) {
        if (this.eatAnimationTick > 4 && this.eatAnimationTick <= 36) {
            float f = ((float)(this.eatAnimationTick - 4) - partialTick) / 32.0f;
            return 0.62831855f + 0.21991149f * Mth.m_14031_((float)(f * 28.7f));
        }
        if (this.eatAnimationTick > 0) {
            return 0.62831855f;
        }
        return this.m_5686_(partialTick) * ((float)Math.PI / 180);
    }

    public boolean m_5545_(LevelAccessor accessor, MobSpawnType reason) {
        List giantsNearby = accessor.m_45976_(Human.class, this.m_20191_().m_82377_(100.0, 10.0, 100.0));
        return giantsNearby.size() < 3;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 0, this::attackPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150930_(Items.f_42583_);
    }
}

