/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.entity.human;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.yzqdev.mod.jeanmod.entity.ModEntities;
import com.yzqdev.mod.jeanmod.entity.human.Human;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.BecomePassiveIfMemoryPresent;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class HumanAI {
    private static final UniformInt ADULT_FOLLOW_RANGE = UniformInt.m_146622_((int)5, (int)16);
    private static final float SPEED_MULTIPLIER_WHEN_MAKING_LOVE = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_IDLING = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_FOLLOWING_ADULT = 1.25f;
    private static final float SPEED_MULTIPLIER_WHEN_TEMPTED = 1.25f;
    private static final float SPEED_MULTIPLIER_WHEN_PANICKING = 2.0f;
    private static final float SPEED_MULTIPLIER_WHEN_PREPARING_TO_RAM = 1.25f;
    private static final UniformInt TIME_BETWEEN_LONG_JUMPS = UniformInt.m_146622_((int)60, (int)120);
    public static final int MAX_LONG_JUMP_HEIGHT = 3;
    public static final int MAX_LONG_JUMP_WIDTH = 4;
    public static final float MAX_JUMP_VELOCITY = 1.5f;

    protected static void initMemories(Human goat, RandomSource random) {
    }

    protected static Brain<Human> makeBrain(Human human, Brain<Human> brain) {
        HumanAI.initCoreActivity(brain);
        HumanAI.initIdleActivity(brain);
        HumanAI.initFightActivity(human, brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    private static void initFightActivity(Human human, Brain<Human> pBrain) {
        pBrain.m_21895_(Activity.f_37988_, 10, ImmutableList.of((Object)BecomePassiveIfMemoryPresent.m_257393_((MemoryModuleType)MemoryModuleType.f_26356_, (int)200), (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.m_257469_((float)1.0f), (Object)BehaviorBuilder.m_257845_(maid -> true, (OneShot)MeleeAttack.m_257733_((int)10)), (Object)StopAttackingIfTargetInvalid.m_257822_()), MemoryModuleType.f_26372_);
    }

    private static void initCoreActivity(Brain<Human> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)new AnimalMakeLove((EntityType)ModEntities.HUMAN.get(), 0.6f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(MemoryModuleType.f_148197_), (Object)new CountDownCooldownTicks(MemoryModuleType.f_148199_)));
    }

    private static void initIdleActivity(Brain<Human> brain) {
        brain.m_21900_(Activity.f_37979_, ImmutableList.of((Object)Pair.of((Object)0, (Object)SetWalkTargetAwayFrom.m_257620_((MemoryModuleType)MemoryModuleType.f_26356_, (float)1.0f, (int)8, (boolean)true)), (Object)Pair.of((Object)0, (Object)StartAttacking.m_257710_(HumanAI::findNearestValidAttackTarget)), (Object)Pair.of((Object)1, (Object)SetEntityLookTargetSometimes.m_257472_((EntityType)EntityType.f_20532_, (float)6.0f, (UniformInt)UniformInt.m_146622_((int)30, (int)60))), (Object)Pair.of((Object)2, (Object)new FollowTemptation(livingEntity -> Float.valueOf(1.25f))), (Object)Pair.of((Object)3, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.m_257965_((float)1.0f), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.m_257764_((float)1.0f, (int)3), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1))))));
    }

    public static void hurtBy(Human human, LivingEntity target) {
        if (Sensor.m_182377_((LivingEntity)human, (LivingEntity)target) && !BehaviorUtils.m_22598_((LivingEntity)human, (LivingEntity)target, (double)1.0)) {
            HumanAI.setAngryTarget(human, target);
        }
    }

    public static void setAngryTarget(Human human, LivingEntity target) {
        human.m_6274_().m_21936_(MemoryModuleType.f_26326_);
        human.m_6274_().m_21882_(MemoryModuleType.f_26372_, (Object)target, 200L);
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(Human human) {
        Optional optional = BehaviorUtils.m_22610_((LivingEntity)human, (MemoryModuleType)MemoryModuleType.f_26334_);
        if (optional.isPresent() && Sensor.m_182377_((LivingEntity)human, (LivingEntity)((LivingEntity)optional.get()))) {
            return optional;
        }
        Optional optionalLivingEntity = HumanAI.getTargetLivings(human);
        return optionalLivingEntity.isPresent() ? optionalLivingEntity : human.m_6274_().m_21952_(MemoryModuleType.f_26333_);
    }

    private static Optional<LivingEntity> getTargetLivings(Human human) {
        Optional livings = human.m_6274_().m_21952_(MemoryModuleType.f_148205_);
        return livings.flatMap(i -> i.m_186116_(v -> v instanceof Zombie));
    }

    private static Optional<? extends LivingEntity> getTargetIfWithinRange(Human human, MemoryModuleType<? extends LivingEntity> pMemoryType) {
        return human.m_6274_().m_21952_(pMemoryType).filter(livingEntity -> livingEntity.m_19950_((Entity)human, 12.0));
    }

    public static void updateActivity(Human human) {
        Brain<Human> brains = human.m_6274_();
        if (LocalDateTime.now().getSecond() % 5 == 0) {
            // empty if block
        }
        brains.m_21926_((List)ImmutableList.of((Object)Activity.f_37988_, (Object)Activity.f_37979_));
        human.m_21561_(brains.m_21874_(MemoryModuleType.f_26372_));
    }

    public static Ingredient getTemptations() {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42583_});
    }
}

