/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.entity.maid;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import com.yzqdev.mod.jeanmod.JeanMod;
import com.yzqdev.mod.jeanmod.block.ModBlocks;
import com.yzqdev.mod.jeanmod.entity.ModEntities;
import com.yzqdev.mod.jeanmod.entity.maid.MaidAi;
import com.yzqdev.mod.jeanmod.inventory.maid.MaidScreenHandler;
import com.yzqdev.mod.jeanmod.item.ModTags;
import com.yzqdev.mod.jeanmod.network.NetworkHandler;
import com.yzqdev.mod.jeanmod.network.PlayMaidSoundMessage;
import com.yzqdev.mod.jeanmod.sound.ModSoundEvents;
import com.yzqdev.mod.jeanmod.sound.SoundUtil;
import com.yzqdev.mod.jeanmod.util.ItemUtil;
import com.yzqdev.mod.jeanmod.util.ModSensorTypes;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Maid
extends TamableAnimal
implements GeoEntity,
InventoryCarrier {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Boolean> DATA_BEGGING = SynchedEntityData.m_135353_(Maid.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> DATA_SOUND_PACK_ID = SynchedEntityData.m_135353_(Maid.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Integer> DATA_LEVEL = SynchedEntityData.m_135353_(Maid.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_EXP = SynchedEntityData.m_135353_(Maid.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int MAX_HEALTH = 50;
    private final String DATA_SOUND_PACK_ID_TAG = "data_sound_pack_id_tag";
    public static final String MAID_INVENTORY_TAG = "MaidInventory";
    private final SimpleContainer inventory = new SimpleContainer(72);
    private final SimpleContainer armorInv = new SimpleContainer(4);
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super Maid>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26814_, (Object)SensorType.f_26812_, (Object)SensorType.f_26810_, ModSensorTypes.MAID_HOSTILE_SENSOR.get(), (Object)((SensorType)ModSensorTypes.MAID_PICKUP_ENTITIES_SENSOR_SENSOR_TYPE.get()), (Object)((SensorType)ModSensorTypes.MAID_TEMPTATIONS.get()));
    protected static final ImmutableList<? extends MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_148204_, (Object)MemoryModuleType.f_26323_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26368_, (Object)((MemoryModuleType)ModSensorTypes.VISIBLE_PICKUP_ENTITIES.get()), (Object)MemoryModuleType.f_26375_, (Object)MemoryModuleType.f_26372_, (Object)MemoryModuleType.f_26373_, (Object[])new MemoryModuleType[]{MemoryModuleType.f_148196_, MemoryModuleType.f_148197_, MemoryModuleType.f_26356_, MemoryModuleType.f_26357_, MemoryModuleType.f_148198_, MemoryModuleType.f_217768_});
    private int pickupSoundCount = 5;
    public static final String LEVEL_KEY = "MaidLevel";
    public static final String EXP_KEY = "MaidExp";

    public Maid(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.m_21573_().m_7008_(true);
        this.m_21553_(true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22278_, (double)0.4f).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22281_, 3.0);
    }

    public SimpleContainer m_35311_() {
        return this.inventory;
    }

    public SimpleContainer getArmorInv() {
        return this.armorInv;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(ModTags.maidFood);
    }

    public float m_21535_() {
        return 16.0f;
    }

    public boolean m_21533_() {
        return this.m_21444_(this.m_20183_());
    }

    public boolean m_21444_(BlockPos pos) {
        if (this.m_21536_()) {
            return this.m_21534_().m_123331_((Vec3i)pos) < (double)(this.m_21535_() * this.m_21535_());
        }
        return true;
    }

    protected Brain.Provider<Maid> m_5490_() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return MaidAi.makeBrain(this, (Brain<Maid>)this.m_5490_().m_22073_(dynamic));
    }

    public Brain<Maid> m_6274_() {
        return super.m_6274_();
    }

    private boolean isInCombat() {
        LivingEntity target = this.m_5448_();
        return target != null && target.m_6084_();
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_19797_ % 40 == 0) {
            if (!this.isInCombat()) {
                if (!this.m_9236_().f_46443_ && this.m_6084_() && this.m_21824_()) {
                    this.m_5634_(1.0f);
                }
            } else if (!this.m_9236_().f_46443_ && this.m_6084_() && this.m_21824_()) {
                this.m_5634_(2.0f);
            }
        }
    }

    protected void m_8024_() {
        this.m_9236_().m_46473_().m_6180_("maidBrain");
        this.m_6274_().m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        this.m_9236_().m_46473_().m_7238_();
        this.m_9236_().m_46473_().m_6180_("maidActivityUpdate");
        MaidAi.updateActivity(this);
        this.m_9236_().m_46473_().m_7238_();
        super.m_8024_();
    }

    public static boolean checkMaidSpawnRules(@NotNull EntityType<Maid> type, @NotNull LevelAccessor level, MobSpawnType spawnType, @NotNull BlockPos pos, @NotNull RandomSource random) {
        return true;
    }

    public void m_5496_(SoundEvent sound, float volume, float pitch) {
        if (sound.m_11660_().m_135815_().contains("maid")) {
            NetworkHandler.sendToNearby((Entity)this, new PlayMaidSoundMessage(sound.m_11660_(), this.getSoundPackId(), this.m_19879_()), 16);
        } else {
            super.m_5496_(sound, volume, pitch);
        }
    }

    public String getSoundPackId() {
        return (String)this.f_19804_.m_135370_(DATA_SOUND_PACK_ID);
    }

    public void setSoundPackId(String soundPackId) {
        this.f_19804_.m_135381_(DATA_SOUND_PACK_ID, (Object)soundPackId);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.m_5448_() != null) {
            return SoundUtil.attackSound(this, (SoundEvent)ModSoundEvents.MAID_IDLE.get(), 0.7f);
        }
        return SoundUtil.environmentSound(this, (SoundEvent)ModSoundEvents.MAID_IDLE.get(), 0.5f);
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        if (pDamageSource.m_7639_() instanceof Player) {
            return (SoundEvent)ModSoundEvents.MAID_PLAYER.get();
        }
        return (SoundEvent)ModSoundEvents.MAID_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.MAID_DEATH.get();
    }

    public float m_6100_() {
        return 1.0f;
    }

    public void m_7581_(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.m_32055_();
        if (!itemstack.m_41619_()) {
            this.m_21053_(itemEntity);
            this.m_7938_((Entity)itemEntity, itemstack.m_41613_());
            itemstack.m_41774_(itemstack.m_41613_());
            if (itemstack.m_41619_()) {
                itemEntity.m_146870_();
            }
        }
    }

    protected void m_6138_() {
        super.m_6138_();
        List entityList = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82377_(0.5, 0.0, 0.5), i -> true);
        if (!entityList.isEmpty() && this.m_6084_()) {
            for (Entity entity : entityList) {
                if (!(entity instanceof ItemEntity)) continue;
                ItemEntity itemEntity = (ItemEntity)entity;
                this.pickupItem(itemEntity, false);
            }
        }
    }

    public boolean pickupItem(ItemEntity entityItem, boolean simulate) {
        if (!this.m_9236_().f_46443_ && entityItem.m_6084_() && !entityItem.m_32063_()) {
            ItemStack itemstack = entityItem.m_32055_();
            int count = itemstack.m_41613_();
            if (count == (itemstack = this.inventory.m_19173_(itemstack)).m_41613_()) {
                return false;
            }
            if (!simulate) {
                this.m_7938_((Entity)entityItem, count - itemstack.m_41613_());
                --this.pickupSoundCount;
                if (this.pickupSoundCount == 0) {
                    this.m_5496_((SoundEvent)ModSoundEvents.MAID_ITEM_GET.get(), 1.0f, 1.0f);
                    this.pickupSoundCount = 5;
                }
                if (itemstack.m_41619_()) {
                    entityItem.m_146870_();
                } else {
                    entityItem.m_32045_(itemstack);
                }
            }
            return true;
        }
        return false;
    }

    public int getLevel(TamableAnimal entity) {
        return (Integer)this.f_19804_.m_135370_(DATA_LEVEL);
    }

    public void setLevel(TamableAnimal entity, int level) {
        if (level < 51) {
            this.f_19804_.m_135381_(DATA_LEVEL, (Object)level);
            entity.getPersistentData().m_128405_(LEVEL_KEY, level);
            this.onLevelUp();
        }
    }

    public int getExp(TamableAnimal entity) {
        return (Integer)this.f_19804_.m_135370_(DATA_EXP);
    }

    public int setExp(int exp) {
        this.f_19804_.m_135381_(DATA_EXP, (Object)exp);
        return (Integer)this.f_19804_.m_135370_(DATA_EXP);
    }

    public void addExp(TamableAnimal entity, int exp) {
        int currentExp = this.getExp(entity);
        int currentLevel = this.getLevel(entity);
        int requiredExp = 100 + 20 * currentLevel;
        if ((currentExp += exp) >= requiredExp) {
            this.setLevel(entity, currentLevel + 1);
            currentExp -= requiredExp;
        }
        this.f_19804_.m_135381_(DATA_EXP, (Object)Math.max(currentExp, 0));
    }

    public boolean m_6779_(LivingEntity pTarget) {
        LivingEntity livingEntity;
        if (this.m_21824_() && (livingEntity = this.m_269323_()) instanceof Player) {
            LivingEntity lastHurtByMob;
            Player player = (Player)livingEntity;
            if (this.m_21825_()) {
                return false;
            }
            if (pTarget instanceof Player) {
                return false;
            }
            if (pTarget instanceof TamableAnimal) {
                TamableAnimal tamableAnimal = (TamableAnimal)pTarget;
                if (player.m_20148_().equals(tamableAnimal.m_21805_())) {
                    return false;
                }
            }
            if (pTarget.equals((Object)(lastHurtByMob = player.m_21188_()))) {
                return true;
            }
            LivingEntity lastHurtMob = player.m_21214_();
            if (pTarget.equals((Object)lastHurtMob)) {
                return true;
            }
        }
        if (pTarget instanceof Enemy) {
            return true;
        }
        LivingEntity maidLastHurtByMob = this.m_21188_();
        return pTarget.equals((Object)maidLastHurtByMob);
    }

    public void getAvailableInv() {
    }

    public LivingEntity m_5448_() {
        return this.f_20939_.m_21952_(MemoryModuleType.f_26372_).orElse(null);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean flag = super.m_6469_(source, amount);
        if (this.m_9236_().f_46443_) {
            return false;
        }
        if (flag && source.m_7639_() instanceof LivingEntity) {
            this.triggerAnim("attacked_controller", "attacked");
            MaidAi.wasHurtBy(this, (LivingEntity)source.m_7639_());
        }
        return flag;
    }

    public double m_142593_(LivingEntity pEntity) {
        float attackDistance = 2.0f + (float)this.getLevel(this) / 7.0f;
        return attackDistance * attackDistance;
    }

    public void m_21837_(boolean inSittingPose) {
        super.m_21837_(inSittingPose);
        this.m_21839_(inSittingPose);
        if (inSittingPose) {
            this.m_21573_().m_26573_();
            this.m_6274_().m_21936_(MemoryModuleType.f_26372_);
            this.m_6710_(null);
        }
    }

    protected void m_8025_() {
        super.m_8025_();
        DebugPackets.m_133695_((LivingEntity)this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_LEVEL, (Object)0);
        this.f_19804_.m_135372_(DATA_EXP, (Object)0);
        this.f_19804_.m_135372_(DATA_BEGGING, (Object)false);
        this.f_19804_.m_135372_(DATA_SOUND_PACK_ID, (Object)"atri_sound_pack");
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.m_253224_(tag);
        this.setLevel(this, tag.m_128451_("Level"));
        this.addExp(this, tag.m_128451_("Exp"));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Level", this.getLevel(this));
        tag.m_128405_("Exp", this.getExp(this));
        tag.m_128359_("data_sound_pack_id_tag", "atri_sound_pack");
        this.m_252802_(tag);
    }

    public void onLevelUp() {
        Maid entity = this;
        int level = this.getLevel(entity);
        this.m_21051_(Attributes.f_22276_).m_22100_(100.0 + (double)(level * 10));
        this.m_21153_(100.0f + (float)(level * 10));
        AttributeInstance maidDamage = this.m_21051_(Attributes.f_22281_);
        if (maidDamage.m_22115_() < 30.0) {
            maidDamage.m_22100_(3.0 + (double)(level * 2));
        }
        if (level >= 5) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19600_, Integer.MAX_VALUE, 1));
        }
    }

    public double getMaidAttackDamage() {
        AttributeInstance health = this.m_21051_(Attributes.f_22276_);
        AttributeInstance maidDamage = this.m_21051_(Attributes.f_22281_);
        return maidDamage.m_22115_();
    }

    protected void m_5849_() {
        if (this.m_21824_()) {
            this.m_21051_(Attributes.f_22276_).m_22100_(100.0);
            this.m_21153_(100.0f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(50.0);
        }
    }

    public boolean isBegging() {
        return (Boolean)this.f_19804_.m_135370_(DATA_BEGGING);
    }

    public void setBegging(boolean begging) {
        this.f_19804_.m_135381_(DATA_BEGGING, (Object)begging);
    }

    @NotNull
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.m_9236_().f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)player) || this.m_21824_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_6898_(itemstack) && !this.m_21824_()) {
            if (itemstack.m_204117_(ModTags.maidFood)) {
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                if (this.f_19796_.m_188503_(3) == 0) {
                    this.m_21828_(player);
                    this.m_21837_(true);
                    this.m_6710_(null);
                    this.m_6274_().m_21936_(MemoryModuleType.f_26372_);
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (this.m_21824_() && this.m_21830_((LivingEntity)player)) {
            if (itemstack.m_204117_(ModTags.maidFood)) {
                if (!this.m_21824_() || !this.m_21830_((LivingEntity)player)) {
                    return super.m_6071_(player, hand);
                }
                if (this.m_21223_() != this.m_21233_()) {
                    this.m_5634_(4.0f);
                    if (!player.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                } else {
                    return super.m_6071_(player, hand);
                }
                this.m_9236_().m_7605_((Entity)this, (byte)10);
                return InteractionResult.SUCCESS;
            }
            InteractionResult interactionresult = super.m_6071_(player, hand);
            if (!interactionresult.m_19077_() && this.m_21830_((LivingEntity)player)) {
                if (player.m_6144_()) {
                    this.m_21837_(!this.m_21825_());
                    this.f_20899_ = false;
                    System.out.println("\u5750\u4e0b");
                    this.m_21573_().m_26573_();
                    this.m_6274_().m_21936_(MemoryModuleType.f_26372_);
                    this.m_6710_(null);
                    return InteractionResult.SUCCESS;
                }
                if (player instanceof ServerPlayer) {
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                        public Component m_5446_() {
                            return Maid.this.m_5446_();
                        }

                        @Nullable
                        public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
                            return new MaidScreenHandler(pContainerId, pPlayerInventory, Maid.this.m_19879_(), Maid.this.getMaidAttackDamage());
                        }
                    }, buf -> {
                        buf.writeInt(this.m_19879_());
                        buf.writeDouble(this.m_21051_(Attributes.f_22281_).m_22115_());
                    });
                }
            }
        }
        return super.m_6071_(player, hand);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob otherParent) {
        Maid maidBaby = (Maid)((EntityType)ModEntities.MAID_ENTITY_TYPE.get()).m_20615_((Level)level);
        maidBaby.m_21816_(this.m_21805_());
        maidBaby.m_7105_(true);
        return maidBaby;
    }

    protected void m_5907_() {
        super.m_5907_();
        Direction face = this.m_6350_();
        CompoundTag compoundTag = new CompoundTag();
        this.m_20223_(compoundTag);
        if (compoundTag.m_128441_("PetHomeEntityData") && !compoundTag.m_128469_("PetHomeEntityData").m_128456_()) {
            JeanMod.LOGGER.info("pet bed exist");
        } else {
            BlockPos playerPos = this.m_20183_();
            BlockPos leftPos = playerPos.m_121945_(face);
            Level level = this.m_9236_();
            if (level.m_46859_(leftPos)) {
                BlockPos rightPos = leftPos.m_121945_(face.m_122427_());
                if (!level.m_8055_(leftPos).m_247087_() || !level.m_8055_(rightPos).m_247087_()) {
                    return;
                }
                level.m_7731_(leftPos, ((Block)ModBlocks.COMPRESSED_BARRELS.get()).m_49966_(), 3);
                BlockEntity blockEntity = level.m_7702_(leftPos);
                if (blockEntity == null) {
                    return;
                }
                LazyOptional containerCap = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER);
                if (!containerCap.isPresent()) {
                    return;
                }
                if (containerCap.isPresent()) {
                    IItemHandler containerHandler = (IItemHandler)containerCap.resolve().get();
                    this.m_6167_().forEach(i -> ItemUtil.transferItem(i, containerHandler));
                    this.armorInv.f_19147_.forEach(i -> ItemUtil.transferItem(i, containerHandler));
                    this.inventory.f_19147_.forEach(i -> ItemUtil.transferItem(i, containerHandler));
                }
            } else {
                this.m_6167_().forEach(i -> ItemUtil.dropItem(this.m_9236_(), i, (LivingEntity)this));
                this.armorInv.f_19147_.forEach(i -> ItemUtil.dropItem(this.m_9236_(), i, (LivingEntity)this));
                this.inventory.f_19147_.forEach(i -> ItemUtil.dropItem(this.m_9236_(), i, (LivingEntity)this));
            }
        }
    }

    private PlayState predicate(AnimationState animationState) {
        if (animationState.isMoving()) {
            double velocity = this.m_20184_().m_82553_();
            Optional target = this.m_6274_().m_21952_(MemoryModuleType.f_26372_);
            if (target.isPresent()) {
                animationState.getController().setAnimation(RawAnimation.begin().then("move.run", Animation.LoopType.LOOP));
            } else {
                animationState.getController().setAnimation(RawAnimation.begin().then("move.walk", Animation.LoopType.LOOP));
            }
            return PlayState.CONTINUE;
        }
        animationState.getController().setAnimation(RawAnimation.begin().then("misc.idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    private PlayState attackPredicate(AnimationState state) {
        if (this.f_20911_ && state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            state.getController().forceAnimationReset();
            state.getController().setAnimation(RawAnimation.begin().then("attack.strike", Animation.LoopType.PLAY_ONCE));
            this.f_20911_ = false;
        }
        return PlayState.CONTINUE;
    }

    private PlayState jumpPredicate(AnimationState state) {
        if (this.m_20069_() || this.m_20096_() || this.m_20159_() || this.f_20916_ > 0) {
            return PlayState.STOP;
        }
        state.getController().setAnimation(RawAnimation.begin().then("jump", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    private PlayState diePredicate(AnimationState state) {
        if (this.m_21224_()) {
            return state.setAndContinue(DefaultAnimations.DIE);
        }
        state.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericLivingController((GeoAnimatable)this)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "sit", 0, state -> {
            if (this.m_21825_()) {
                state.getController().setAnimation(RawAnimation.begin().then("sit", Animation.LoopType.PLAY_ONCE));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 0, this::attackPredicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "die", 0, this::diePredicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attacked_controller", event -> PlayState.STOP).triggerableAnim("attacked", RawAnimation.begin().then("attacked", Animation.LoopType.PLAY_ONCE))});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "eat_mainhand_controller", event -> PlayState.STOP).triggerableAnim("use_mainhand:eat", RawAnimation.begin().then("use_mainhand:eat", Animation.LoopType.PLAY_ONCE))});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "eat_controller", event -> PlayState.STOP).triggerableAnim("use_offhand:eat", RawAnimation.begin().then("use_offhand:eat", Animation.LoopType.PLAY_ONCE))});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, state -> {
            if (this.m_20159_()) {
                state.getController().setAnimation(RawAnimation.begin().then("chair", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "swim", 0, state -> {
            if (this.m_20069_() && !this.m_20096_()) {
                state.getController().setAnimation(RawAnimation.begin().then("swim_stand", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "jumpController", 0, this::jumpPredicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "tempt", 0, state -> {
            if (this.isBegging()) {
                state.getController().setAnimation(RawAnimation.begin().then("beg", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static boolean canSpawn(EntityType<Maid> maidEntityType, ServerLevelAccessor serverLevelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        return true;
    }
}

