/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.entity.maid;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.yzqdev.mod.jeanmod.entity.ModEntities;
import com.yzqdev.mod.jeanmod.entity.maid.Maid;
import com.yzqdev.mod.jeanmod.entity.maid.MaidBegTask;
import com.yzqdev.mod.jeanmod.entity.maid.MaidFollowOwnerTask;
import com.yzqdev.mod.jeanmod.entity.maid.MaidHealSelfTask;
import com.yzqdev.mod.jeanmod.entity.maid.MaidPickupEntitiesTask;
import com.yzqdev.mod.jeanmod.item.ModTags;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.BecomePassiveIfMemoryPresent;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.crafting.Ingredient;

public class MaidAi {
    public static Brain<?> makeBrain(Maid maid, Brain<Maid> maidBrain) {
        MaidAi.initCoreActivity(maidBrain);
        MaidAi.initIdleActivity(maidBrain);
        MaidAi.initFightActivity(maid, maidBrain);
        maidBrain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        maidBrain.m_21944_(Activity.f_37979_);
        maidBrain.m_21962_();
        return maidBrain;
    }

    public static void initCoreActivity(Brain<Maid> brain) {
        brain.m_21900_(Activity.f_37978_, ImmutableList.of((Object)Pair.of((Object)0, (Object)new Swim(0.8f)), (Object)Pair.of((Object)0, (Object)new AnimalMakeLove((EntityType)ModEntities.MAID_ENTITY_TYPE.get(), 0.6f)), (Object)Pair.of((Object)0, (Object)new LookAtTargetSink(45, 90)), (Object)Pair.of((Object)10, (Object)((Object)new MaidPickupEntitiesTask(1.2f))), (Object)Pair.of((Object)2, (Object)new MoveToTargetSink()), (Object)Pair.of((Object)3, (Object)((Object)new MaidFollowOwnerTask(1.2f, 2))), (Object)Pair.of((Object)3, (Object)((Object)new MaidHealSelfTask())), (Object)Pair.of((Object)4, (Object)new CountDownCooldownTicks(MemoryModuleType.f_148197_))));
    }

    public static void initIdleActivity(Brain<Maid> brain) {
        brain.m_21900_(Activity.f_37979_, ImmutableList.of((Object)Pair.of((Object)1, (Object)new FollowTemptation(i -> Float.valueOf(1.2f))), (Object)Pair.of((Object)3, (Object)((Object)new MaidBegTask())), (Object)Pair.of((Object)1, (Object)StartAttacking.m_257741_(maid -> true, MaidAi::findNearestValidAttackTarget)), (Object)Pair.of((Object)3, (Object)MaidAi.getLookAndRandomWalk())));
    }

    private static RunOne getLookAndRandomWalk() {
        Pair lookToPlayer = Pair.of((Object)SetEntityLookTarget.m_258096_((EntityType)EntityType.f_20532_, (float)5.0f), (Object)1);
        Pair lookToEntity = Pair.of((Object)SetEntityLookTargetSometimes.m_257458_((float)6.0f, (UniformInt)UniformInt.m_146622_((int)30, (int)60)), (Object)1);
        Pair lookToMaid = Pair.of((Object)SetEntityLookTarget.m_258096_((EntityType)((EntityType)ModEntities.MAID_ENTITY_TYPE.get()), (float)5.0f), (Object)1);
        Pair lookToWolf = Pair.of((Object)SetEntityLookTarget.m_258096_((EntityType)EntityType.f_20499_, (float)5.0f), (Object)1);
        Pair lookToCat = Pair.of((Object)SetEntityLookTarget.m_258096_((EntityType)EntityType.f_20553_, (float)5.0f), (Object)1);
        Pair lookToParrot = Pair.of((Object)SetEntityLookTarget.m_258096_((EntityType)EntityType.f_20508_, (float)5.0f), (Object)1);
        Pair walkRandomly = Pair.of((Object)RandomStroll.m_257960_((float)1.0f, (int)5, (int)3), (Object)1);
        Pair noLook = Pair.of((Object)new DoNothing(30, 60), (Object)2);
        return new RunOne((List)ImmutableList.of((Object)lookToEntity, (Object)lookToPlayer, (Object)lookToMaid, (Object)lookToWolf, (Object)lookToCat, (Object)lookToParrot, (Object)walkRandomly, (Object)noLook));
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(Maid maid) {
        Optional livings = maid.m_6274_().m_21952_(MemoryModuleType.f_148205_);
        Optional attackTarget = maid.m_6274_().m_21952_(MemoryModuleType.f_26372_);
        if (attackTarget.isPresent()) {
            return attackTarget;
        }
        return livings.flatMap(i -> i.m_186116_(v -> maid.m_6779_((LivingEntity)v)));
    }

    public static void initFightActivity(Maid maid, Brain<Maid> brain) {
        brain.m_21907_(Activity.f_37988_, ImmutableList.of((Object)Pair.of((Object)1, (Object)BecomePassiveIfMemoryPresent.m_257393_((MemoryModuleType)MemoryModuleType.f_26356_, (int)200)), (Object)Pair.of((Object)1, (Object)BehaviorBuilder.m_257845_(i -> true, (OneShot)MeleeAttack.m_257733_((int)10))), (Object)Pair.of((Object)1, (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.m_257469_((float)1.2f)), (Object)Pair.of((Object)1, (Object)StopAttackingIfTargetInvalid.m_257822_()), (Object)Pair.of((Object)1, (Object)EraseMemoryIf.m_258093_(MaidAi::attackTargetTooFar, (MemoryModuleType)MemoryModuleType.f_26372_))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT)), (Set)ImmutableSet.of((Object)MemoryModuleType.f_26372_));
    }

    public static boolean attackTargetTooFar(Maid maid) {
        Optional attackTarget = maid.m_6274_().m_21952_(MemoryModuleType.f_26372_);
        return attackTarget.map(livingEntity -> maid.m_20238_(livingEntity.m_20182_()) > 4.0).orElse(true);
    }

    private static RunOne<Maid> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.m_257965_((float)0.25f), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.m_257764_((float)0.3f, (int)3), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    public static void broadcastUniversalAnger(Maid maid, LivingEntity entity) {
        Optional livings = maid.m_6274_().m_21952_(MemoryModuleType.f_148204_);
        livings.ifPresent(v -> v.stream().filter(live -> {
            Maid maidEntity;
            return live instanceof Maid && !(maidEntity = (Maid)((Object)((Object)live))).m_21824_();
        }).forEach(i -> MaidAi.setAttackTarget((Maid)((Object)((Object)i)), entity)));
    }

    public static void updateActivity(Maid maid) {
        if (maid.m_21825_()) {
            maid.m_21573_().m_26573_();
            maid.m_6274_().m_21936_(MemoryModuleType.f_26372_);
            maid.m_6710_(null);
        }
        Brain<Maid> brain = maid.m_6274_();
        List running = brain.m_21956_();
        Optional maidBeg = brain.m_21952_(MemoryModuleType.f_148198_);
        if (maidBeg.isPresent() && ((Boolean)maidBeg.get()).booleanValue()) {
            maid.setBegging(true);
        } else {
            maid.setBegging(false);
        }
        if (LocalDateTime.now().getSecond() % 5 == 0) {
            // empty if block
        }
        brain.m_21926_((List)ImmutableList.of((Object)Activity.f_37988_, (Object)Activity.f_37979_));
        maid.m_21561_(brain.m_21874_(MemoryModuleType.f_26372_));
    }

    private static void setAttackTarget(Maid maid, LivingEntity pTarget) {
        Brain<Maid> brain = maid.m_6274_();
        brain.m_21936_(MemoryModuleType.f_26326_);
        brain.m_21879_(MemoryModuleType.f_26372_, (Object)pTarget);
    }

    public static void wasHurtBy(Maid maid, LivingEntity entity) {
        Brain<Maid> brain = maid.m_6274_();
        brain.m_21936_(MemoryModuleType.f_26357_);
        brain.m_21936_(MemoryModuleType.f_26375_);
        if (!BehaviorUtils.m_22598_((LivingEntity)maid, (LivingEntity)entity, (double)4.0) && Sensor.m_148312_((LivingEntity)maid, (LivingEntity)entity)) {
            MaidAi.setAttackTarget(maid, entity);
            if (!maid.m_21824_()) {
                MaidAi.broadcastUniversalAnger(maid, entity);
            }
        }
    }

    public static Ingredient getTemptations() {
        return Ingredient.m_204132_(ModTags.maidFood);
    }
}

