/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.entity.maid;

import com.google.common.collect.ImmutableMap;
import com.yzqdev.mod.jeanmod.entity.maid.Maid;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import org.jetbrains.annotations.Nullable;

public class MaidFollowOwnerTask
extends Behavior<Maid> {
    private static final int MAX_TELEPORT_ATTEMPTS_TIMES = 10;
    private final float speedModifier;
    private final int stopDistance;

    public MaidFollowOwnerTask(float speedModifier, int stopDistance) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED));
        this.speedModifier = speedModifier;
        this.stopDistance = stopDistance;
    }

    protected void start(ServerLevel worldIn, Maid maid, long gameTimeIn) {
        LivingEntity owner = maid.m_269323_();
        int startDistance = (int)maid.m_21535_() - 2;
        int minTeleportDistance = startDistance + 4;
        if (this.ownerStateConditions(owner) && !maid.m_19950_((Entity)owner, startDistance)) {
            if (!maid.m_19950_((Entity)owner, minTeleportDistance) && !maid.m_21825_()) {
                this.teleportToOwner(maid, owner);
            } else if (!this.ownerIsWalkTarget(maid, owner)) {
                BehaviorUtils.m_22590_((LivingEntity)maid, (Entity)owner, (float)this.speedModifier, (int)this.stopDistance);
            }
        }
    }

    private void teleportToOwner(Maid maid, LivingEntity owner) {
        BlockPos blockPos = owner.m_20183_();
        for (int i = 0; i < 10; ++i) {
            int x = this.randomIntInclusive(maid.m_217043_(), -3, 3);
            int y = this.randomIntInclusive(maid.m_217043_(), -1, 1);
            int z = this.randomIntInclusive(maid.m_217043_(), -3, 3);
            if (!this.maybeTeleportTo(maid, owner, blockPos.m_123341_() + x, blockPos.m_123342_() + y, blockPos.m_123343_() + z)) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(Maid maid, LivingEntity owner, int x, int y, int z) {
        if (this.teleportTooClosed(owner, x, z)) {
            return false;
        }
        if (!this.canTeleportTo(maid, new BlockPos(x, y, z))) {
            return false;
        }
        maid.m_7678_((double)x + 0.5, y, (double)z + 0.5, maid.m_146908_(), maid.m_146909_());
        maid.m_21573_().m_26573_();
        maid.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        maid.m_6274_().m_21936_(MemoryModuleType.f_26371_);
        maid.m_6274_().m_21936_(MemoryModuleType.f_26372_);
        maid.m_6274_().m_21936_(MemoryModuleType.f_26377_);
        return true;
    }

    private boolean teleportTooClosed(LivingEntity owner, int x, int z) {
        return Math.abs((double)x - owner.m_20185_()) < 2.0 && Math.abs((double)z - owner.m_20189_()) < 2.0;
    }

    private boolean canTeleportTo(Maid maid, BlockPos pos) {
        BlockPathTypes pathNodeType = WalkNodeEvaluator.m_77604_((BlockGetter)maid.m_9236_(), (BlockPos.MutableBlockPos)pos.m_122032_());
        if (pathNodeType == BlockPathTypes.WALKABLE) {
            BlockPos blockPos = pos.m_121996_((Vec3i)maid.m_20183_());
            return maid.m_9236_().m_45756_((Entity)maid, maid.m_20191_().m_82338_(blockPos));
        }
        return false;
    }

    private int randomIntInclusive(RandomSource random, int min, int max) {
        return random.m_188503_(max - min + 1) + min;
    }

    private boolean ownerStateConditions(@Nullable LivingEntity owner) {
        return owner != null && !owner.m_5833_() && !owner.m_21224_();
    }

    private boolean ownerIsWalkTarget(Maid maid, LivingEntity owner) {
        return maid.m_6274_().m_21952_(MemoryModuleType.f_26370_).map(target -> {
            if (target.m_26420_() instanceof EntityTracker) {
                return ((EntityTracker)target.m_26420_()).m_147481_().equals((Object)owner);
            }
            return false;
        }).orElse(false);
    }
}

