/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.entity.maid;

import com.google.common.collect.ImmutableMap;
import com.yzqdev.mod.jeanmod.entity.maid.Maid;
import com.yzqdev.mod.jeanmod.entity.maid.MaidCheckRateTask;
import com.yzqdev.mod.jeanmod.item.ModTags;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class MaidHealSelfTask
extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 50;
    private static final int MAX_CHECK_MISSING_HEATH = 2;
    private static final int MAX_PROBABILITY = 5;

    public MaidHealSelfTask() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of());
        this.setMaxCheckRate(50);
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel serverLevel, Maid maid) {
        if (super.checkExtraStartConditions(serverLevel, maid)) {
            float missingHealth = maid.m_21233_() - maid.m_21223_();
            return !maid.m_5803_() && missingHealth >= 2.0f;
        }
        return false;
    }

    protected void start(ServerLevel serverLevel, Maid maid, long gameTime) {
        for (InteractionHand hand : InteractionHand.values()) {
            FoodProperties foodProperties;
            ItemStack itemInHand = maid.m_21120_(hand);
            if (itemInHand.m_41619_() || !itemInHand.m_41614_() || (foodProperties = itemInHand.getFoodProperties((LivingEntity)maid)) == null) continue;
            if (hand == InteractionHand.MAIN_HAND) {
                maid.triggerAnim("eat_mainhand_controller", "use_mainhand:eat");
            } else {
                maid.triggerAnim("eat_controller", "use_offhand:eat");
            }
            maid.m_6672_(hand);
            int nutrition = foodProperties.m_38744_();
            float saturation = foodProperties.m_38745_();
            float total = (float)nutrition + saturation;
            maid.m_5634_(total);
            if (maid.m_21824_()) {
                maid.addExp(maid, 1);
            }
            return;
        }
        InteractionHand eanHand = InteractionHand.OFF_HAND;
        for (InteractionHand hand : InteractionHand.values()) {
            if (!maid.m_21120_(hand).m_41619_()) continue;
            eanHand = hand;
            break;
        }
        ItemStack itemInHand = maid.m_21120_(eanHand);
        boolean hasFood = false;
        SimpleContainer backpackInv = maid.m_35311_();
        for (int i = 0; i < backpackInv.m_6643_(); ++i) {
            ItemStack stack = backpackInv.m_8020_(i);
            if (stack.m_41619_() || !stack.m_41614_()) continue;
            ItemStack handStack = itemInHand.m_41777_();
            maid.m_21008_(eanHand, stack);
            itemInHand = maid.m_21120_(eanHand);
            backpackInv.m_6836_(i, Items.f_41852_.m_7968_());
            hasFood = true;
            break;
        }
        if (hasFood && itemInHand.m_204117_(ModTags.maidFood)) {
            FoodProperties foodProperties = itemInHand.getFoodProperties((LivingEntity)maid);
            if (foodProperties != null) {
                if (eanHand == InteractionHand.MAIN_HAND) {
                    maid.triggerAnim("eat_mainhand_controller", "use_mainhand:eat");
                } else {
                    maid.triggerAnim("eat_controller", "use_offhand:eat");
                }
                maid.m_6672_(eanHand);
                int nutrition = foodProperties.m_38744_();
                float saturation = foodProperties.m_38745_();
                float total = (float)nutrition + saturation;
                maid.m_5634_(total);
                if (maid.m_21824_()) {
                    maid.addExp(maid, 1);
                }
            }
            return;
        }
    }
}

