/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.entity.maid;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.yzqdev.mod.jeanmod.entity.maid.Maid;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.BlockAndItemGeoLayer;

public class MaidHeldItemGeoLayer
extends BlockAndItemGeoLayer<Maid> {
    private static final String KEY_ITEM_LEFT_HAND = "itemLeftHand";
    private static final String KEY_ITEM_RIGHT_HAND = "itemRightHand";
    private static final String KEY_DRIPLEAF_RIGHT_HAND = "dripleaf_right_hand";

    public MaidHeldItemGeoLayer(GeoRenderer<Maid> renderer) {
        super(renderer);
    }

    @Nullable
    public ItemStack getStackForBone(GeoBone bone, Maid maid) {
        ItemStack mainStack = maid.m_21205_();
        ItemStack offStack = maid.m_21206_();
        switch (bone.getName()) {
            case "LeftHandLocator": {
                return offStack;
            }
            case "RightHandLocator": {
                return mainStack;
            }
        }
        return null;
    }

    @Nullable
    public BlockState getBlockForBone(GeoBone bone, Maid maid) {
        if (bone.getName().equals(KEY_DRIPLEAF_RIGHT_HAND)) {
            return Blocks.f_152545_.m_49966_();
        }
        return null;
    }

    public ItemDisplayContext getTransformTypeForStack(GeoBone bone, ItemStack stack, Maid maid) {
        return switch (bone.getName()) {
            case "LeftHandLocator", "RightHandLocator" -> ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
            default -> ItemDisplayContext.NONE;
        };
    }

    public void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, Maid maid, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
        ItemStack mainStack = maid.m_21205_();
        ItemStack offStack = maid.m_21206_();
        if (stack == mainStack) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            if (stack.m_41720_() instanceof ShieldItem) {
                poseStack.m_85837_(0.0, 0.125, -0.25);
            }
        } else if (stack == offStack) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            if (stack.m_41720_() instanceof ShieldItem) {
                poseStack.m_85837_(0.0, 0.125, 1.25);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            }
        }
        super.renderStackForBone(poseStack, bone, stack, (GeoAnimatable)maid, bufferSource, partialTick, packedLight, packedOverlay);
    }
}

