/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.event;

import com.github.tartaricacid.touhoulittlemaid.entity.monster.EntityFairy;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.brigadier.CommandDispatcher;
import com.yzqdev.mod.jeanmod.command.RootCommand;
import com.yzqdev.mod.jeanmod.datagen.LangDefinition;
import com.yzqdev.mod.jeanmod.entity.elf.EntityElf;
import com.yzqdev.mod.jeanmod.entity.maid.Maid;
import com.yzqdev.mod.jeanmod.event.NbtCommands;
import com.yzqdev.mod.jeanmod.inventory.golem.GolemInventoryScreenHandler;
import com.yzqdev.mod.jeanmod.item.ModItems;
import com.yzqdev.mod.jeanmod.util.GlobalHelper;
import com.yzqdev.mod.jeanmod.util.ItemUtil;
import com.yzqdev.mod.jeanmod.util.Placeutil;
import com.yzqdev.mod.jeanmod.util.SlimeEvent;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="jean")
public class MiscEvent {
    @SubscribeEvent
    public static void onCommandsRegister(RegisterCommandsEvent event) {
        CommandBuildContext context = event.getBuildContext();
        RootCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), context);
        new NbtCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void smeltingItem(FurnaceFuelBurnTimeEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.m_41720_().equals(ModItems.BAMBOO_COAL.get())) {
            event.setBurnTime(200);
        }
    }

    @SubscribeEvent
    public static void onWorldJoin(EntityJoinLevelEvent e) {
        Player player;
        Entity entity = e.getEntity();
        if (entity instanceof Player) {
            player = (Player)entity;
            int duration = 86400000;
            if (GlobalHelper.isDevelopmentEnvironment()) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, duration));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, duration, 255));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, duration, 2));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19618_, duration, 255));
            }
        }
        if (!SlimeEvent.onWorldJoin(e.getLevel(), e.getEntity())) {
            e.setCanceled(true);
        }
        if ((entity = e.getEntity()) instanceof Zombie) {
            player = (Zombie)entity;
        }
        if ((entity = e.getEntity()) instanceof EntityFairy) {
            EntityFairy entityFairy = (EntityFairy)entity;
            entityFairy.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)entityFairy, new Class[0]));
        }
        if (e.getEntity() instanceof EntityElf) {
            e.getEntity().m_213846_((Component)Component.m_237113_((String)"\u5973\u4ec6\u7cbe\u7075\u51fa\u73b0\u4e86!"));
        }
    }

    @SubscribeEvent
    public static void EntityDieEvt(LivingDeathEvent event) {
        Maid animal;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Maid) {
            Maid maid = (Maid)livingEntity;
        }
        if ((livingEntity = event.getSource().m_7639_()) instanceof Maid && (animal = (Maid)livingEntity).m_21824_()) {
            LivingEntity target = event.getEntity();
            int exp = (int)target.m_21233_() / 20;
            animal.addExp(animal, exp);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntityAttack(LivingAttackEvent event) {
        LivingEntity target = event.getEntity();
        DamageSource damageSource = event.getSource();
        Entity attacker = event.getSource().m_7639_();
        if (attacker instanceof TamableAnimal && target instanceof TamableAnimal) {
            TamableAnimal attackerTame = (TamableAnimal)attacker;
            TamableAnimal targetTame = (TamableAnimal)target;
            if (attackerTame.m_21824_() && targetTame.m_21824_() && attackerTame.m_269323_() == targetTame.m_269323_()) {
                event.setCanceled(true);
            }
        }
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            Item item = player.m_21205_().m_41720_();
            if (player.f_19853_.f_46443_ && FMLEnvironment.dist == Dist.CLIENT) {
                if (item == ModItems.COPY_ID_ITEM.get()) {
                    ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey((Object)target.m_6095_());
                    if (key == null) {
                        return;
                    }
                    Minecraft.m_91087_().f_91068_.m_90911_(key.toString());
                    player.m_213846_((Component)Component.m_237115_((String)LangDefinition.get_entity_id).m_7220_((Component)Component.m_237113_((String)key.toString())));
                }
                if (item != ModItems.NIGHT_VISION_CARROT.get() || !(target instanceof EntityMaid) || ((EntityMaid)target).m_21223_() > 1.0f) {
                    // empty if block
                }
            }
        }
    }

    @SubscribeEvent
    public static void clickItem(LivingEntityUseItemEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            boolean flag;
            Player player = (Player)livingEntity;
            boolean bl = flag = player.m_21205_().m_41720_() == ModItems.COPY_ID_ITEM.get();
            if (flag) {
                // empty if block
            }
        }
    }

    @SubscribeEvent
    public static void leftClick(PlayerInteractEvent.LeftClickEmpty event) {
        Player player = event.getEntity();
        ItemStack itemStack = player.m_21205_();
        if (itemStack.m_41720_() == ModItems.COPY_ID_ITEM.get()) {
            System.out.println(player.m_7755_().getString() + " left-clicked with the item!");
        }
    }

    @SubscribeEvent
    public static void onPlayerInteractBlock(PlayerInteractEvent.RightClickBlock event) {
    }

    @SubscribeEvent
    public static void onItemRightClick(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        ItemStack item = event.getItemStack();
        Level level = event.getLevel();
        InteractionHand hand = event.getHand();
        HitResult result = player.m_19907_(5.0, 0.0f, false);
        if (result.m_6662_() == HitResult.Type.ENTITY || result.m_6662_() == HitResult.Type.BLOCK) {
            if (event.getItemStack().m_150930_((Item)ModItems.CHAIR_ME_ITEM.get())) {
                event.setCanceled(true);
            }
            if (event.getItemStack().m_150930_((Item)ModItems.PHOTO_ITEM.get())) {
                event.setCanceled(true);
            }
        } else {
            System.out.println(result.m_6662_().toString());
            ItemStack itemStack = event.getItemStack();
        }
    }

    @SubscribeEvent
    public static void copyEntityId(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        Entity target = event.getTarget();
        Level level = event.getLevel();
        ItemStack itemstack = event.getItemStack();
        if (hand.equals((Object)InteractionHand.MAIN_HAND) && itemstack.m_150930_((Item)ModItems.PHOTO_ITEM.get())) {
            event.setCanceled(true);
            Optional<TamableAnimal> result = Placeutil.rayTraceMaid(player, 8.0);
            if (!level.m_5776_() && result.isPresent()) {
                CompoundTag entityTag = new CompoundTag();
                CompoundTag photoTag = new CompoundTag();
                CompoundTag data = itemstack.m_41783_();
                if (data == null) {
                    target.m_20240_(entityTag);
                    entityTag.m_128359_("id", target.m_20078_());
                    photoTag.m_128365_("MaidInfo", (Tag)entityTag);
                    itemstack.m_41751_(photoTag);
                    itemstack.m_41714_((Component)Component.m_237113_((String)ItemUtil.getEntityInItemStack(itemstack)).m_130940_(ChatFormatting.AQUA));
                    target.m_146870_();
                    player.m_213846_((Component)Component.m_237113_((String)"\u5df2\u4fdd\u5b58!"));
                    event.setCanceled(true);
                } else {
                    player.m_213846_((Component)Component.m_237113_((String)"\u8fd9\u5f20\u7167\u7247\u5df2\u7ecf\u6709\u5185\u5bb9\u4e86!").m_130940_(ChatFormatting.RED));
                }
            }
        }
        if (player.m_21120_(hand).m_150930_((Item)ModItems.COPY_ID_ITEM.get())) {
            if (player.f_19853_.f_46443_ && FMLEnvironment.dist == Dist.CLIENT) {
                Minecraft.m_91087_().execute(() -> MiscEvent.copyEntityId(player, target));
            }
            event.setCanceled(true);
        }
        if (!player.f_19853_.m_5776_() && FMLEnvironment.dist == Dist.CLIENT) {
            ServerPlayer serverPlayer;
            if (!player.m_5833_() && !target.m_213877_() && target instanceof IronGolem) {
                IronGolem ironGolem = (IronGolem)target;
                if (player.m_6144_() && player.m_21120_(hand).m_150930_(Items.f_42416_) && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer2 = (ServerPlayer)player;
                    System.out.println("\u70b9\u51fb\u94c1\u5080\u5121");
                    NetworkHooks.openScreen((ServerPlayer)serverPlayer2, (MenuProvider)GolemInventoryScreenHandler.createMenuProvider(ironGolem), buf -> buf.writeInt(ironGolem.m_19879_()));
                    event.setCanceled(true);
                }
            }
            if (player.m_21120_(hand).m_150930_((Item)ModItems.RELEASE_PET_ITEM.get()) && target instanceof TamableAnimal) {
                TamableAnimal tamableAnimal = (TamableAnimal)target;
                tamableAnimal.m_7105_(false);
                tamableAnimal.m_21816_(null);
                tamableAnimal.m_21839_(false);
                tamableAnimal.m_21837_(false);
                event.setCanceled(true);
            }
            if (player.m_21120_(hand).m_150930_((Item)ModItems.CHAIR_ME_ITEM.get()) && player instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)player;
                if (serverPlayer.m_146862_(e -> e instanceof LivingEntity)) {
                    serverPlayer.m_20153_();
                    player.m_6674_(hand);
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetPassengersPacket((Entity)serverPlayer));
                } else {
                    boolean success = target.m_7998_((Entity)serverPlayer, true);
                    player.m_6674_(hand);
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetPassengersPacket((Entity)serverPlayer));
                    event.setCanceled(true);
                }
            }
            if (player.m_21120_(hand).m_150930_(Items.f_42450_) && player instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)player;
                serverPlayer.m_7998_(target, true);
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetPassengersPacket((Entity)serverPlayer));
                event.setCanceled(true);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void copyEntityId(Player player, Entity target) {
        String uuid = target.m_20149_();
        System.out.println(target.m_19879_());
        Minecraft.m_91087_().f_91068_.m_90911_(uuid);
        player.m_213846_((Component)Component.m_237115_((String)LangDefinition.get_entity_uuid).m_7220_((Component)Component.m_237113_((String)uuid)));
    }
}

