/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.event;

import com.mojang.logging.LogUtils;
import com.yzqdev.mod.jeanmod.Config;
import com.yzqdev.mod.jeanmod.item.ModItems;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="jean")
public class ToolTipEvent {
    public static final Logger LOGGER = LogUtils.getLogger();

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void ItemToolTipEvent(ItemTooltipEvent event) {
        ItemStack itemStack = event.getItemStack();
        if (!itemStack.m_41619_()) {
            String st;
            if (itemStack.m_41720_() == ModItems.COMMAND_ITEM.get() && itemStack.m_41782_()) {
                assert (itemStack.m_41783_() != null);
                String customValue = itemStack.m_41783_().m_128461_("cmd");
                MutableComponent cmdTxt = Component.m_237113_((String)customValue).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED));
                event.getToolTip().add(Component.m_237113_((String)"Command: ").m_7220_((Component)cmdTxt));
            }
            boolean showStuff = true;
            if (Config.showAsAdvanced) {
                showStuff = Minecraft.m_91087_().f_91066_.f_92125_;
            }
            if (showStuff) {
                int BurnTime = ForgeHooks.getBurnTime((ItemStack)itemStack, null);
                if (BurnTime > 0) {
                    String var10000 = ToolTipEvent.getTimeStringShort(BurnTime / 20);
                    String st2 = var10000 + " (" + BurnTime + ")";
                    event.getToolTip().add(1, Component.m_237110_((String)"tip.bettertags.burn", (Object[])new Object[]{st2}).m_130940_(ChatFormatting.GRAY));
                }
                if (itemStack.m_41782_()) {
                    if (itemStack.m_41776_() != 0 && itemStack.m_41773_() == 0) {
                        event.getToolTip().add(1, Component.m_237110_((String)"tip.bettertags.durability", (Object[])new Object[]{itemStack.m_41776_()}).m_130940_(ChatFormatting.GRAY));
                    }
                    if (Screen.m_96639_()) {
                        if (Config.showNBTLength) {
                            event.getToolTip().add(Component.m_237110_((String)"tip.bettertags.length", (Object[])new Object[]{ToolTipEvent.getNBTSize(itemStack.m_41783_())}).m_130940_(ChatFormatting.DARK_GRAY));
                        }
                        CompoundTag itemTag = itemStack.m_41783_();
                        event.getToolTip().add(NbtUtils.m_178061_((Tag)itemTag));
                    } else {
                        event.getToolTip().add(Component.m_237110_((String)"tip.bettertags.ctrl", (Object[])new Object[]{Component.m_237115_((String)"tip.ctrl").m_130940_(ChatFormatting.YELLOW)}).m_130940_(ChatFormatting.GRAY));
                    }
                }
                Collection<ResourceLocation> iTag = ToolTipEvent.getTags(itemStack.m_204131_());
                if (Screen.m_96638_()) {
                    if (!iTag.isEmpty()) {
                        event.getToolTip().add(Component.m_237115_((String)"tip.bettertags.item_tags").m_130940_(ChatFormatting.GRAY));
                        iTag.forEach(tag -> event.getToolTip().add(Component.m_237113_((String)("  #" + tag.toString())).m_130940_(ChatFormatting.DARK_GRAY)));
                    }
                    if ((block = Block.m_49814_((Item)itemStack.m_41720_())) != Blocks.f_50016_ && !(iTag = ToolTipEvent.getTags(block.m_49966_().m_204343_())).isEmpty()) {
                        event.getToolTip().add(Component.m_237115_((String)"tip.bettertags.block_tags").m_130940_(ChatFormatting.GRAY));
                        iTag.forEach(tag -> event.getToolTip().add(Component.m_237113_((String)("  #" + tag)).m_130940_(ChatFormatting.DARK_GRAY)));
                    }
                } else {
                    if (iTag.isEmpty() && (block = Block.m_49814_((Item)itemStack.m_41720_())) != Blocks.f_50016_) {
                        iTag = ToolTipEvent.getTags(block.m_49966_().m_204343_());
                    }
                    if (!iTag.isEmpty()) {
                        event.getToolTip().add(Component.m_237110_((String)"tip.bettertags.shift", (Object[])new Object[]{Component.m_237115_((String)"tip.shift").m_130940_(ChatFormatting.YELLOW)}).m_130940_(ChatFormatting.GRAY));
                    }
                }
            }
            if (itemStack.m_41720_() == Items.f_42718_) {
                if (Config.showInfoStew && itemStack.m_41782_() && itemStack.m_41783_().m_128425_("Effects", 9)) {
                    ListTag nbtList = itemStack.m_41783_().m_128437_("Effects", 10);
                    int line = 1;
                    for (int i = 0; i < nbtList.size(); ++i) {
                        MobEffect statusEffect;
                        int j = 160;
                        CompoundTag nbtCompound2 = nbtList.m_128728_(i);
                        if (nbtCompound2.m_128425_("EffectDuration", 3)) {
                            j = nbtCompound2.m_128451_("EffectDuration");
                        }
                        if ((statusEffect = MobEffect.m_19453_((int)nbtCompound2.m_128445_("EffectId"))) == null) continue;
                        event.getToolTip().add(line, Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{statusEffect.m_19482_(), StringUtil.m_14404_((int)j)}).m_130940_(statusEffect.m_19483_().m_19497_()));
                        ++line;
                    }
                }
            } else if (itemStack.m_41720_() != Items.f_42785_ && itemStack.m_41720_() != Items.f_42786_) {
                LocalPlayer player;
                if (itemStack.m_41720_() == Items.f_42524_) {
                    ClientLevel level;
                    if (Config.showInfoClock && (level = Minecraft.m_91087_().f_91073_) != null) {
                        event.getToolTip().add(1, Component.m_237110_((String)"tip.bettertags.clock", (Object[])new Object[]{(int)((level.m_46468_() + 6000L) / 24000L) + 1, ToolTipEvent.getGameTime((Level)level, Config.isTwelves)}));
                    }
                } else if (itemStack.m_41720_() == Items.f_220211_ && Boolean.valueOf(Config.showInfoRecovery).booleanValue() && (player = Minecraft.m_91087_().f_91074_) != null) {
                    player.m_219759_().ifPresent(globalPos -> {
                        event.getToolTip().add(1, Component.m_237115_((String)("biome." + globalPos.m_122640_().m_135782_().m_214298_())).m_130940_(ChatFormatting.GRAY));
                        event.getToolTip().add(2, Component.m_237110_((String)"tip.coords", (Object[])new Object[]{globalPos.m_122646_().m_123341_(), globalPos.m_122646_().m_123342_(), globalPos.m_122646_().m_123343_()}).m_130940_(ChatFormatting.GRAY));
                        event.getToolTip().add(3, Component.m_237110_((String)"tip.distance", (Object[])new Object[]{String.format(Locale.ROOT, "%2d", ToolTipEvent.distanceTo(player.m_20183_(), globalPos.m_122646_()))}).m_130940_(ChatFormatting.GRAY));
                    });
                }
            } else if (Boolean.valueOf(Config.showInfoBees).booleanValue() && itemStack.m_41782_()) {
                CompoundTag nbt = itemStack.m_41783_().m_128469_("BlockEntityTag");
                ListTag nbtList = nbt.m_128437_("Bees", 10);
                if (nbtList.isEmpty()) {
                    event.getToolTip().add(1, Component.m_237115_((String)"tip.bettertags.bee_empty").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
                } else {
                    event.getToolTip().add(1, Component.m_237110_((String)"tip.bettertags.bees", (Object[])new Object[]{nbtList.size()}).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
                }
                nbt = itemStack.m_41783_().m_128469_("BlockStateTag");
                event.getToolTip().add(2, Component.m_237110_((String)"tip.bettertags.bee_level", (Object[])new Object[]{nbt.m_128461_("honey_level")}).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
            }
            if (Config.showModName && (st = ToolTipEvent.getModName(itemStack)) != null) {
                event.getToolTip().add(Component.m_237113_((String)st).m_130940_(ChatFormatting.BLUE));
            }
        }
    }

    private static int distanceTo(BlockPos start, BlockPos end) {
        float f = start.m_123341_() - end.m_123341_();
        float f1 = start.m_123342_() - end.m_123342_();
        float f2 = start.m_123343_() - end.m_123343_();
        return (int)Mth.m_14116_((float)(f * f + f1 * f1 + f2 * f2));
    }

    @Nullable
    private static String getModName(ItemStack itemStack) {
        String modName = itemStack.m_41720_().getCreatorModId(itemStack);
        return modName != null ? ModList.get().getModContainerById(modName).map(modContainer -> modContainer.getModInfo().getDisplayName()).orElse(StringUtils.capitalize((String)modName)) : null;
    }

    private static int getNBTSize(@Nullable CompoundTag nbt) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.m_130079_(nbt);
        buffer.release();
        return buffer.writerIndex();
    }

    private static <TYPE> Collection<ResourceLocation> getTags(Stream<TagKey<TYPE>> tags) {
        return tags.map(TagKey::f_203868_).collect(Collectors.toUnmodifiableSet());
    }

    private static String getTimeStringShort(int seconds) {
        int days = seconds / 86400;
        int n = seconds % 86400;
        int hours = n / 3600;
        int minutes = (n %= 3600) / 60;
        int secs = n % 60;
        String ss = days != 0 ? String.format("%02d:%02d:%02d:%02d", days, hours, minutes, secs) : (hours != 0 ? String.format("%02d:%02d:%02d", hours, minutes, secs) : String.format("%d:%02d", minutes, secs));
        return ss;
    }

    private static String getGameTime(Level level, boolean isTwelveHour) {
        double ratio = 16.666666666666668;
        int dayTime = (int)((level.m_46468_() + 6000L) % 24000L);
        int hours = dayTime / 1000;
        int minutes = (int)((double)(dayTime % 1000) / ratio);
        String post = "";
        if (isTwelveHour) {
            if (hours >= 12) {
                hours -= 12;
                post = " PM";
            } else {
                post = " AM";
            }
        }
        return (hours < 10 ? "0" : "") + hours + ":" + (minutes < 10 ? "0" : "") + minutes + post;
    }
}

