/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.inventory;

import com.yzqdev.mod.jeanmod.inventory.ISwingAttack;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;

public class SwingAttackGoal<T extends Mob>
extends Goal {
    private static final Predicate<Entity> iMobTarget = p_213685_0_ -> !(p_213685_0_ instanceof IronGolem);
    private final T mobEntity;
    private int attackingTimer;
    private int cooldownTimer = -1;

    public SwingAttackGoal(T mobEntity) {
        this.mobEntity = mobEntity;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity livingEntity;
        if (this.cooldownTimer > 0) {
            --this.cooldownTimer;
        }
        if ((livingEntity = this.mobEntity.m_5448_()) != null && livingEntity.m_6084_() && this.cooldownTimer <= 0 && livingEntity.m_20280_(this.mobEntity) < 32.0 && livingEntity.m_20096_()) {
            this.cooldownTimer = 100 + this.mobEntity.m_217043_().m_188503_(100);
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        return (float)this.attackingTimer < 25.0f;
    }

    public void m_8056_() {
        super.m_8056_();
        ((ISwingAttack)this.mobEntity).setSwingAttack(true);
        this.attackingTimer = 0;
        this.mobEntity.m_9236_().m_7605_(this.mobEntity, (byte)64);
    }

    public void m_8041_() {
        super.m_8041_();
        ((ISwingAttack)this.mobEntity).setSwingAttack(false);
    }

    public void m_8037_() {
        super.m_8037_();
        ++this.attackingTimer;
        if ((float)this.attackingTimer == 5.0f) {
            this.groundAttack();
        }
    }

    private void groundAttack() {
        LivingEntity livingEntity = this.mobEntity.m_5448_();
        if (this.mobEntity.m_20096_()) {
            this.mobEntity.m_5496_(SoundEvents.f_11913_, 1.4f, 1.4f);
            this.mobEntity.m_5496_(SoundEvents.f_12057_, 1.0f, 1.0f);
            for (Entity entity : this.mobEntity.m_9236_().m_6443_(LivingEntity.class, this.mobEntity.m_20191_().m_82400_(8.0), iMobTarget)) {
                boolean flag;
                if (entity instanceof Creeper || !(entity instanceof Enemy) && (livingEntity == null || livingEntity != entity)) continue;
                if (entity.m_20096_() && (flag = entity.m_6469_(this.mobEntity.m_269291_().m_269333_(this.mobEntity), (float)this.mobEntity.m_21133_(Attributes.f_22281_) * 0.75f))) {
                    entity.m_20184_().m_82520_(0.0, (double)0.4f, 0.0);
                }
                this.launch(entity);
            }
        }
    }

    private void launch(Entity p_33340_) {
        double d0 = p_33340_.m_20185_() - this.mobEntity.m_20185_();
        double d1 = p_33340_.m_20189_() - this.mobEntity.m_20189_();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        p_33340_.m_5997_(d0 / d2 * 4.0, 0.2, d1 / d2 * 4.0);
    }

    public boolean m_183429_() {
        return true;
    }
}

