/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.inventory.maid;

import com.mojang.blaze3d.systems.RenderSystem;
import com.yzqdev.mod.jeanmod.entity.maid.Maid;
import com.yzqdev.mod.jeanmod.inventory.maid.MaidScreenHandler;
import com.yzqdev.mod.jeanmod.util.GlobalHelper;
import java.text.DecimalFormat;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class MaidInventoryScreen
extends AbstractContainerScreen<MaidScreenHandler> {
    private final Maid maid;
    private static final ResourceLocation MAID_SCREEN_TEXTURE = GlobalHelper.id("textures/gui/maid_inv.png");
    private static final ResourceLocation SIDE = ResourceLocation.fromNamespaceAndPath((String)"jean", (String)"textures/gui/maid_gui_side.png");
    public static final ResourceLocation EMPTY_HELD_SLOT_TEXTURE = GlobalHelper.id("item/empty_held_item_slot");
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("00");
    private float xMouse;
    private float yMouse;

    public MaidInventoryScreen(MaidScreenHandler menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, menu.maid.m_5446_());
        this.maid = menu.maid;
    }

    protected void m_7286_(GuiGraphics context, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)MAID_SCREEN_TEXTURE);
        int centerX = (this.f_96543_ - this.f_97726_) / 2;
        int centerY = (this.f_96544_ - this.f_97727_) / 2;
        context.m_280218_(MAID_SCREEN_TEXTURE, centerX - 76, centerY - 54, 0, 0, this.f_97726_ + 80, this.f_97727_ + 90);
        int inventorySize = this.maid.m_35311_().m_6643_();
        InventoryScreen.m_274545_((GuiGraphics)context, (int)(centerX - 38), (int)(centerY + 4), (int)35, (float)((float)(centerX - 41) - this.xMouse), (float)((float)(centerY + 75 - 50) - this.yMouse), (LivingEntity)this.maid);
        this.drawBaseInfoGui(context);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_ - 54, 0x404040, false);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        this.xMouse = mouseX;
        this.yMouse = mouseY;
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void drawBaseInfoGui(GuiGraphics graphics) {
        int leftMove = 72;
        int topMove = -30;
        int widthShrink = 0;
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
        graphics.m_280218_(SIDE, this.f_97735_ + 53 - leftMove, this.f_97736_ + 113 + topMove, 0, 0, 9 - widthShrink, 9);
        graphics.m_280218_(SIDE, this.f_97735_ + 5 - leftMove, this.f_97736_ + 113 + topMove, 0, 9, 47 - widthShrink, 9);
        double hp = this.maid.m_21223_() / this.maid.m_21233_();
        graphics.m_280218_(SIDE, this.f_97735_ + 7 - leftMove, this.f_97736_ + 115 + topMove, 2, 18, (int)(43.0 * hp) - widthShrink, 5);
        this.drawNumberScale(graphics, this.maid.m_21223_(), this.f_97735_ + 63 - leftMove, this.f_97736_ + 114 + topMove);
        graphics.m_280218_(SIDE, this.f_97735_ + 53 - leftMove, this.f_97736_ + 124 + topMove, 9, 0, 9, 9);
        graphics.m_280218_(SIDE, this.f_97735_ + 5 - leftMove, this.f_97736_ + 124 + topMove, 0, 9, 47, 9);
        double armor = this.maid.m_21133_(Attributes.f_22284_) / 20.0;
        graphics.m_280218_(SIDE, this.f_97735_ + 7 - leftMove, this.f_97736_ + 126 + topMove, 2, 23, (int)(43.0 * armor), 5);
        this.drawNumberScale(graphics, this.maid.m_21230_(), this.f_97735_ + 63 - leftMove, this.f_97736_ + 125 + topMove);
        graphics.m_280218_(SIDE, this.f_97735_ + 53 - leftMove, this.f_97736_ + 135 + topMove, 18, 0, 9, 9);
        graphics.m_280218_(SIDE, this.f_97735_ + 5 - leftMove, this.f_97736_ + 135 + topMove, 0, 9, 47, 9);
        int exp = this.maid.getExp(this.maid);
        int maidLevel = this.maid.getLevel(this.maid);
        double percent = (double)exp / (double)(100 + 20 * maidLevel);
        graphics.m_280218_(SIDE, this.f_97735_ + 7 - leftMove, this.f_97736_ + 137 + topMove, 2, 28, (int)(43.0 * percent), 5);
        this.drawNumberScale(graphics, exp, this.f_97735_ + 63 - leftMove, this.f_97736_ + 136 + topMove);
        graphics.m_280218_(SIDE, this.f_97735_ + 53 - leftMove, this.f_97736_ + 146 + topMove, 27, 0, 9, 9);
        graphics.m_280218_(SIDE, this.f_97735_ + 5 - leftMove, this.f_97736_ + 146 + topMove, 0, 9, 47, 9);
        int maidLevel2 = this.maid.getLevel(this.maid);
        double percent2 = (double)maidLevel2 / 50.0;
        graphics.m_280218_(SIDE, this.f_97735_ + 7 - leftMove, this.f_97736_ + 148 + topMove, 2, 33, (int)(43.0 * percent2), 5);
        this.drawNumberScale(graphics, maidLevel2, this.f_97735_ + 63 - leftMove, this.f_97736_ + 147 + topMove);
        graphics.m_280218_(SIDE, this.f_97735_ + 53 - leftMove, this.f_97736_ + 157 + topMove, 36, 0, 9, 9);
        graphics.m_280218_(SIDE, this.f_97735_ + 5 - leftMove, this.f_97736_ + 157 + topMove, 0, 9, 47, 9);
        double maidDamage = ((MaidScreenHandler)this.f_97732_).attackDamage;
        percent = maidDamage / 30.0;
        graphics.m_280218_(SIDE, this.f_97735_ + 7 - leftMove, this.f_97736_ + 159 + topMove, 2, 38, (int)(43.0 * percent), 5);
        this.drawNumberScale(graphics, maidDamage, this.f_97735_ + 63 - leftMove, this.f_97736_ + 156 + topMove);
        graphics.m_280218_(SIDE, this.f_97735_ + 94, this.f_97736_ + 7 + topMove, 107, 0, 149, 21);
        graphics.m_280218_(SIDE, this.f_97735_ + 6, this.f_97736_ + 178 + topMove, 0, 47, 67, 25);
    }

    private void drawNumberScale(GuiGraphics graphics, double value, int posX, int posY) {
        String text = DECIMAL_FORMAT.format(value);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280056_(this.f_96547_, text, posX * 2, posY * 2 + 9 / 2, ChatFormatting.DARK_GRAY.m_126665_().intValue(), false);
        graphics.m_280168_().m_85849_();
    }
}

