/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.inventory.maid;

import com.mojang.datafixers.util.Pair;
import com.yzqdev.mod.jeanmod.entity.maid.Maid;
import com.yzqdev.mod.jeanmod.inventory.ModMenus;
import com.yzqdev.mod.jeanmod.inventory.maid.MaidInventoryScreen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MaidScreenHandler
extends AbstractContainerMenu {
    public Maid maid;
    public double attackDamage;
    private static final ResourceLocation[] TEXTURE_EMPTY_SLOTS = new ResourceLocation[]{InventoryMenu.f_39696_, InventoryMenu.f_39695_, InventoryMenu.f_39694_, InventoryMenu.f_39693_};
    private static final EquipmentSlot[] SLOT_IDS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};

    public MaidScreenHandler(int syncId, Inventory inventory, FriendlyByteBuf buf) {
        this(syncId, inventory, buf.readInt(), buf.readDouble());
    }

    public MaidScreenHandler(int syncId, Inventory playerInventory, int maidId, double attackDamage) {
        super((MenuType)ModMenus.MaidInventory.get(), syncId);
        Entity entity = playerInventory.f_35978_.m_9236_().m_6815_(maidId);
        this.maid = (Maid)entity;
        this.attackDamage = attackDamage;
        SimpleContainer armorInventory = this.maid.getArmorInv();
        this.m_38897_(new MaidHeldItemSlot(-53, 18));
        int rightBorder = -35;
        this.m_38897_(new MaidOffhandSlot(rightBorder, 18));
        int leftMove = -61;
        this.m_38897_(new MaidEquipSlot((Container)armorInventory, 0, leftMove + 8, 35, EquipmentSlot.HEAD));
        this.m_38897_(new MaidEquipSlot((Container)armorInventory, 1, leftMove + 8 + 18, 35, EquipmentSlot.CHEST));
        this.m_38897_(new MaidEquipSlot((Container)armorInventory, 2, leftMove + 8, 53, EquipmentSlot.LEGS));
        this.m_38897_(new MaidEquipSlot((Container)armorInventory, 3, leftMove + 8 + 18, 53, EquipmentSlot.FEET));
        for (int i = 0; i < 4; ++i) {
            EquipmentSlot equipmentSlot = SLOT_IDS[i];
        }
        SimpleContainer inventory2 = this.maid.m_35311_();
        int size = inventory2.m_6643_();
        for (int i = 0; i < 8 && (i + 1) * 9 <= size; ++i) {
            for (int j = 0; j < 9 && i * 9 + j + 1 <= size; ++j) {
                this.m_38897_(new Slot((Container)inventory2, i * 9 + j, 12 + j * 18, -36 + i * 18));
            }
        }
        for (int m = 0; m < 3; ++m) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + m * 9 + 9, 12 + l * 18, 120 + m * 18));
            }
        }
        for (int var14 = 0; var14 < 9; ++var14) {
            this.m_38897_(new Slot((Container)playerInventory, var14, 12 + var14 * 18, 178));
        }
        this.m_38893_(new ContainerListener(){

            public void m_7934_(AbstractContainerMenu handler, int slotId, ItemStack itemStack) {
                switch (slotId) {
                    case 0: {
                        MaidScreenHandler.this.maid.m_21008_(InteractionHand.MAIN_HAND, itemStack);
                        break;
                    }
                    case 1: {
                        MaidScreenHandler.this.maid.m_8061_(EquipmentSlot.OFFHAND, itemStack);
                        break;
                    }
                    case 5: {
                        MaidScreenHandler.this.maid.m_8061_(EquipmentSlot.FEET, itemStack);
                        break;
                    }
                    case 2: {
                        MaidScreenHandler.this.maid.m_8061_(EquipmentSlot.HEAD, itemStack);
                        break;
                    }
                    case 3: {
                        MaidScreenHandler.this.maid.m_8061_(EquipmentSlot.CHEST, itemStack);
                        break;
                    }
                    case 4: {
                        MaidScreenHandler.this.maid.m_8061_(EquipmentSlot.LEGS, itemStack);
                    }
                }
            }

            public void m_142153_(AbstractContainerMenu handler, int property, int value) {
            }
        });
    }

    @NotNull
    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack clickedStack = slot.m_7993_();
            itemStack = clickedStack.m_41777_();
            int inventorySize = this.maid.m_35311_().m_6643_();
            int armorSize = this.maid.getArmorInv().m_6643_();
            int maidSize = inventorySize + armorSize + 2;
            if (index >= 0 && index < maidSize) {
                if (!this.m_38903_(clickedStack, 78, 113, false)) {
                    return ItemStack.f_41583_;
                }
                return ItemStack.f_41583_;
            }
            if (index >= 78 && index <= 113 && !this.m_38903_(clickedStack, 6, 78, false)) {
                if (index < 105 && !this.m_38903_(clickedStack, 105, 113, false)) {
                    return ItemStack.f_41583_;
                }
                if (!this.m_38903_(clickedStack, 105, 113, false)) {
                    return ItemStack.f_41583_;
                }
                return ItemStack.f_41583_;
            }
            if (clickedStack.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemStack;
    }

    public boolean m_6875_(Player player) {
        return this.maid.m_35311_().m_6542_(player) && this.maid.m_6084_() && this.maid.m_20270_((Entity)player) < 8.0f;
    }

    private class MaidHeldItemSlot
    extends Slot {
        public MaidHeldItemSlot(int x, int y) {
            super((Container)new SimpleContainer(1), 0, x, y);
            this.m_269060_(MaidScreenHandler.this.maid.m_21205_());
        }

        @OnlyIn(value=Dist.CLIENT)
        @Nullable
        public Pair<ResourceLocation, ResourceLocation> m_7543_() {
            return Pair.of((Object)InventoryMenu.f_39692_, (Object)MaidInventoryScreen.EMPTY_HELD_SLOT_TEXTURE);
        }
    }

    private class MaidOffhandSlot
    extends Slot {
        public MaidOffhandSlot(int x, int y) {
            super((Container)new SimpleContainer(1), 0, x, y);
            this.m_269060_(MaidScreenHandler.this.maid.m_21206_());
        }

        @OnlyIn(value=Dist.CLIENT)
        @Nullable
        public Pair<ResourceLocation, ResourceLocation> m_7543_() {
            return Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39697_);
        }
    }

    private class MaidEquipSlot
    extends Slot {
        private EquipmentSlot equipmentSlot;

        public MaidEquipSlot(Container container, int slot, int x, int y, EquipmentSlot equipmentSlot) {
            super(container, slot, x, y);
            this.equipmentSlot = equipmentSlot;
            this.m_269060_(MaidScreenHandler.this.maid.m_6844_(equipmentSlot));
        }

        public int m_6641_() {
            return 1;
        }

        public boolean m_5857_(ItemStack itemStack) {
            return itemStack.canEquip(this.equipmentSlot, (Entity)MaidScreenHandler.this.maid) && itemStack.m_41720_().m_142095_();
        }

        public boolean m_8010_(Player playerIn) {
            ItemStack itemstack = this.m_7993_();
            boolean curseEnchant = !itemstack.m_41619_() && !playerIn.m_7500_() && EnchantmentHelper.m_44920_((ItemStack)itemstack);
            return !curseEnchant && super.m_8010_(playerIn);
        }

        public Pair<ResourceLocation, ResourceLocation> m_7543_() {
            return Pair.of((Object)InventoryMenu.f_39692_, (Object)TEXTURE_EMPTY_SLOTS[this.equipmentSlot.m_20749_()]);
        }
    }
}

