/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.network;

import com.yzqdev.mod.jeanmod.entity.human.Human;
import com.yzqdev.mod.jeanmod.sound.human.HumanSoundInstance;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayHumanSoundMessage {
    private static final Logger log = LoggerFactory.getLogger(PlayHumanSoundMessage.class);
    private final ResourceLocation soundEvent;
    private final String soundpackId;
    private final int entityId;

    public PlayHumanSoundMessage(ResourceLocation soundEvent, String soundpackId, int entityId) {
        this.soundEvent = soundEvent;
        this.soundpackId = soundpackId;
        this.entityId = entityId;
    }

    public static void encode(PlayHumanSoundMessage message, FriendlyByteBuf buf) {
        buf.m_130085_(message.soundEvent);
        buf.m_130070_(message.soundpackId);
        buf.writeInt(message.entityId);
    }

    public static PlayHumanSoundMessage decode(FriendlyByteBuf buf) {
        return new PlayHumanSoundMessage(buf.m_130281_(), buf.m_130277_(), buf.readInt());
    }

    public static void handle(PlayHumanSoundMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> PlayHumanSoundMessage.playSound(message));
        }
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playSound(PlayHumanSoundMessage message) {
        Entity entity;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null && (entity = mc.f_91073_.m_6815_(message.entityId)) instanceof Human) {
            Human human = (Human)entity;
            SoundEvent event = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(message.soundEvent);
            if (event != null) {
                System.out.println(event.m_11660_().m_135815_());
                mc.m_91106_().m_120367_((SoundInstance)new HumanSoundInstance(event, message.soundpackId, human));
            }
        }
    }
}

