/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.network;

import com.yzqdev.mod.jeanmod.entity.maid.Maid;
import com.yzqdev.mod.jeanmod.sound.MaidSoundInstance;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayMaidSoundMessage {
    private static final Logger log = LoggerFactory.getLogger(PlayMaidSoundMessage.class);
    private final ResourceLocation soundEvent;
    private final String id;
    private final int entityId;

    public PlayMaidSoundMessage(ResourceLocation soundEvent, String id, int entityId) {
        this.soundEvent = soundEvent;
        this.id = id;
        this.entityId = entityId;
    }

    public static void encode(PlayMaidSoundMessage message, FriendlyByteBuf buf) {
        buf.m_130085_(message.soundEvent);
        buf.m_130070_(message.id);
        buf.m_130130_(message.entityId);
    }

    public static PlayMaidSoundMessage decode(FriendlyByteBuf buf) {
        return new PlayMaidSoundMessage(buf.m_130281_(), buf.m_130277_(), buf.m_130242_());
    }

    public static void handle(PlayMaidSoundMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> PlayMaidSoundMessage.playSound(message));
        }
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playSound(PlayMaidSoundMessage message) {
        Entity entity;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null && (entity = mc.f_91073_.m_6815_(message.entityId)) instanceof Maid) {
            Maid maid = (Maid)entity;
            SoundEvent event = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(message.soundEvent);
            if (event != null) {
                System.out.println(event.m_11660_().m_135815_());
                mc.m_91106_().m_120367_((SoundInstance)new MaidSoundInstance(event, message.id, maid));
            }
        }
    }
}

