/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.sound;

import com.google.common.collect.Maps;
import com.yzqdev.mod.jeanmod.entity.maid.Maid;
import com.yzqdev.mod.jeanmod.sound.ModSoundEvents;
import com.yzqdev.mod.jeanmod.sound.SoundItem;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class SoundUtil {
    public static final Map<String, SoundItem> CACHE = Maps.newLinkedHashMap();
    private static final long MORNING_START = 0L;
    private static final long MORNING_END = 3000L;
    private static final long EVENING_START = 12000L;
    private static final long EVENING_END = 15000L;

    public static SoundEvent environmentSound(Maid maid, SoundEvent fallback, float probability) {
        Level world = maid.m_9236_();
        RandomSource rand = maid.m_217043_();
        BlockPos pos = maid.m_20183_();
        long dayTime = world.m_46468_();
        Biome biome = (Biome)world.m_204166_(pos).m_203334_();
        if (rand.m_188501_() < probability && 0L < dayTime && dayTime < 3000L) {
            return (SoundEvent)ModSoundEvents.MAID_MORNING.get();
        }
        if (rand.m_188501_() < probability && 12000L < dayTime && dayTime < 15000L) {
            return (SoundEvent)ModSoundEvents.MAID_NIGHT.get();
        }
        if (rand.m_188501_() < probability && world.m_46471_() && SoundUtil.isRainBiome(biome, pos)) {
            return (SoundEvent)ModSoundEvents.MAID_RAIN.get();
        }
        if (rand.m_188501_() < probability && world.m_46471_() && SoundUtil.isSnowyBiome(biome, pos)) {
            return (SoundEvent)ModSoundEvents.MAID_SNOW.get();
        }
        if (rand.m_188501_() < probability && biome.m_198904_(pos)) {
            return (SoundEvent)ModSoundEvents.MAID_COLD.get();
        }
        if (rand.m_188501_() < probability && SoundUtil.shouldSnowGolemBurn(biome, pos)) {
            return (SoundEvent)ModSoundEvents.MAID_HOT.get();
        }
        return fallback;
    }

    public static SoundEvent attackSound(Maid maid, SoundEvent fallback, float probability) {
        float rand = maid.m_217043_().m_188501_();
        if (rand < probability) {
            if (rand > probability / 2.0f) {
                return (SoundEvent)ModSoundEvents.MAID_ATTACK.get();
            }
            return (SoundEvent)ModSoundEvents.MAID_FIND_TARGET.get();
        }
        return fallback;
    }

    public static boolean isRainBiome(Biome biome, BlockPos pos) {
        return biome.m_264600_(pos) == Biome.Precipitation.RAIN && !SoundUtil.shouldSnowGolemBurn(biome, pos);
    }

    public static boolean isSnowyBiome(Biome biome, BlockPos pos) {
        return biome.m_264600_(pos) == Biome.Precipitation.SNOW;
    }

    private static boolean shouldSnowGolemBurn(Biome biome, BlockPos pos) {
        return biome.m_47505_(pos) > 1.0f;
    }
}

