/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.util;

import com.yzqdev.mod.jeanmod.JeanMod;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.Villager;
import net.minecraftforge.fml.loading.FMLLoader;

public class GlobalHelper {
    public static boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    public static boolean isVillagerInventoryEmpty(Villager villager) {
        for (int i = 0; i < villager.m_35311_().m_6643_(); ++i) {
            if (villager.m_35311_().m_8020_(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"jean", (String)path);
    }

    public static void copyFolder(Path source, Path target) throws IOException {
        if (!Files.isDirectory(source, new LinkOption[0])) {
            JeanMod.LOGGER.error("Source must be a directory");
        }
        if (!Files.exists(target, new LinkOption[0])) {
            Files.createDirectories(target, new FileAttribute[0]);
        }
        Files.walk(source, new FileVisitOption[0]).forEach(srcPath -> {
            try {
                String relativePath = source.relativize((Path)srcPath).toString();
                Path destPath = target.resolve(relativePath);
                System.out.println("Copying: " + srcPath + " -> " + destPath);
                if (Files.isDirectory(srcPath, new LinkOption[0])) {
                    Files.createDirectories(destPath, new FileAttribute[0]);
                } else {
                    Files.copy(srcPath, destPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                }
            }
            catch (IOException e) {
                JeanMod.LOGGER.error("Failed to copy: " + srcPath, (Throwable)e);
            }
        });
    }
}

