/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class ZipFileCheck {
    private static final int RAW_END_OFFSET = 22;
    private static final int END_OF_DIR_LENGTH = 4;
    private static final byte[] END_OF_DIR = new byte[]{80, 75, 5, 6};

    public static boolean isZipFile(File file) throws IOException {
        if (file.exists() && file.isFile()) {
            if (file.length() <= 26L) {
                return false;
            }
            long fileLength = file.length();
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            randomAccessFile.seek(fileLength - 22L);
            byte[] end = new byte[4];
            randomAccessFile.read(end);
            randomAccessFile.close();
            return ZipFileCheck.isEndOfDir(end);
        }
        return false;
    }

    private static boolean isEndOfDir(byte[] src) {
        if (src.length != 4) {
            return false;
        }
        for (int i = 0; i < src.length; ++i) {
            if (src[i] == END_OF_DIR[i]) continue;
            return false;
        }
        return true;
    }
}

