/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.command;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class RandomSetSampler {
    public static <T> List<T> getRandomElements(Set<T> set, int count) {
        if (set.size() < count) {
            throw new IllegalArgumentException("Set size < " + count);
        }
        Random rand = new Random();
        ArrayList<T> result = new ArrayList<T>(count);
        Iterator<T> iterator = set.iterator();
        int[] indices = rand.ints(0, set.size()).distinct().limit(count).sorted().toArray();
        int currentIndex = 0;
        for (int i = 0; i < indices.length; ++i) {
            int targetIndex = indices[i];
            while (currentIndex < targetIndex && iterator.hasNext()) {
                iterator.next();
                ++currentIndex;
            }
            if (!iterator.hasNext()) continue;
            result.add(iterator.next());
            ++currentIndex;
        }
        return result;
    }
}

