/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.entity.gangster;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.yzqdev.mod.jeanmod.entity.gangster.Gangster;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4095;
import net.minecraft.class_4101;
import net.minecraft.class_4110;
import net.minecraft.class_4112;
import net.minecraft.class_4118;
import net.minecraft.class_4120;
import net.minecraft.class_4121;
import net.minecraft.class_4125;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4168;
import net.minecraft.class_4215;
import net.minecraft.class_4802;
import net.minecraft.class_4808;
import net.minecraft.class_4813;
import net.minecraft.class_4816;
import net.minecraft.class_4818;
import net.minecraft.class_4822;
import net.minecraft.class_4824;
import net.minecraft.class_4828;
import net.minecraft.class_5355;
import net.minecraft.class_6019;
import net.minecraft.class_7894;
import net.minecraft.class_7895;
import net.minecraft.class_7898;

public class GangsterAi {
    public static final int REPELLENT_DETECTION_RANGE_HORIZONTAL = 8;
    public static final int REPELLENT_DETECTION_RANGE_VERTICAL = 4;
    private static final class_6019 RETREAT_DURATION = class_4802.method_24505((int)5, (int)20);
    private static final int ATTACK_DURATION = 200;
    private static final int DESIRED_DISTANCE_FROM_PIGLIN_WHEN_IDLING = 8;
    private static final int DESIRED_DISTANCE_FROM_PIGLIN_WHEN_RETREATING = 15;
    private static final int ATTACK_INTERVAL = 40;
    private static final int BABY_ATTACK_INTERVAL = 15;
    private static final int REPELLENT_PACIFY_TIME = 200;
    private static final class_6019 ADULT_FOLLOW_RANGE = class_6019.method_35017((int)5, (int)16);
    private static final float SPEED_MULTIPLIER_WHEN_AVOIDING_REPELLENT = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_RETREATING = 1.3f;
    private static final float SPEED_MULTIPLIER_WHEN_MAKING_LOVE = 0.6f;
    private static final float SPEED_MULTIPLIER_WHEN_IDLING = 0.4f;
    private static final float SPEED_MULTIPLIER_WHEN_FOLLOWING_ADULT = 0.6f;

    protected static class_4095<?> makeBrain(class_4095<Gangster> pBrain) {
        GangsterAi.initCoreActivity(pBrain);
        GangsterAi.initIdleActivity(pBrain);
        GangsterAi.initFightActivity(pBrain);
        GangsterAi.initRetreatActivity(pBrain);
        pBrain.method_18890((Set)ImmutableSet.of((Object)class_4168.field_18594));
        pBrain.method_18897(class_4168.field_18595);
        pBrain.method_24536();
        return pBrain;
    }

    private static void initCoreActivity(class_4095<Gangster> pBrain) {
        pBrain.method_18882(class_4168.field_18594, 0, ImmutableList.of((Object)new class_4125(0.8f), (Object)new class_4110(45, 90), (Object)new class_4112()));
    }

    private static void initIdleActivity(class_4095<Gangster> pBrain) {
        pBrain.method_18882(class_4168.field_18595, 10, ImmutableList.of((Object)class_4808.method_46908((class_4140)class_4140.field_22474, (int)200), (Object)class_4121.method_47091((class_4140)class_4140.field_22474, (float)1.0f, (int)8, (boolean)true), (Object)class_4824.method_47119(GangsterAi::findNearestValidAttackTarget), (Object)class_7898.method_47227(Gangster::isAdult, (class_7894)class_4121.method_24603((class_4140)class_4140.field_22345, (float)0.4f, (int)8, (boolean)false)), (Object)class_7895.method_47067((float)8.0f, (class_6019)class_6019.method_35017((int)30, (int)60)), (Object)class_5355.method_46896((class_6019)ADULT_FOLLOW_RANGE, (float)0.6f)));
    }

    private static void initFightActivity(class_4095<Gangster> pBrain) {
        pBrain.method_24527(class_4168.field_22396, 10, ImmutableList.of((Object)class_4808.method_46908((class_4140)class_4140.field_22474, (int)200), (Object)class_4822.method_47094((float)1.0f), (Object)class_7898.method_47227(Gangster::isAdult, (class_7894)class_4816.method_46987((int)40)), (Object)class_7898.method_47227(class_1296::method_6109, (class_7894)class_4816.method_46987((int)15)), (Object)class_4828.method_47132(), (Object)class_4813.method_46922(GangsterAi::isBreeding, (class_4140)class_4140.field_22355)), class_4140.field_22355);
    }

    private static void initRetreatActivity(class_4095<Gangster> pBrain) {
        pBrain.method_24527(class_4168.field_22399, 10, ImmutableList.of((Object)class_4121.method_24603((class_4140)class_4140.field_22357, (float)1.3f, (int)15, (boolean)false), (Object)class_7895.method_47067((float)8.0f, (class_6019)class_6019.method_35017((int)30, (int)60)), (Object)class_4813.method_46922(GangsterAi::wantsToStopFleeing, (class_4140)class_4140.field_22357)), class_4140.field_22357);
    }

    private static class_4118<Gangster> createIdleMovementBehaviors() {
        return new class_4118((List)ImmutableList.of((Object)Pair.of((Object)class_4818.method_47014((float)0.4f), (Object)2), (Object)Pair.of((Object)class_4120.method_47104((float)0.4f, (int)3), (Object)2), (Object)Pair.of((Object)new class_4101(30, 60), (Object)1)));
    }

    protected static void updateActivity(Gangster pGangster) {
        class_4095<Gangster> brain = pGangster.method_18868();
        class_4168 activity = brain.method_24538().orElse(null);
        brain.method_24531((List)ImmutableList.of((Object)class_4168.field_22396, (Object)class_4168.field_22399, (Object)class_4168.field_18595));
        class_4168 activity1 = brain.method_24538().orElse(null);
        if (activity != activity1) {
            GangsterAi.getSoundForCurrentActivity(pGangster).ifPresent(pGangster::playSoundEvent);
        }
        pGangster.method_19540(brain.method_18896(class_4140.field_22355));
    }

    protected static void onHitTarget(Gangster pGangster, class_1309 pTarget) {
        if (!pGangster.method_6109()) {
            if (pTarget.method_5864() == class_1299.field_22281 && GangsterAi.piglinsOutnumberHoglins(pGangster)) {
                GangsterAi.setAvoidTarget(pGangster, pTarget);
                GangsterAi.broadcastRetreat(pGangster, pTarget);
            } else {
                GangsterAi.broadcastAttackTarget(pGangster, pTarget);
            }
        }
    }

    private static void broadcastRetreat(Gangster pGangster, class_1309 pTarget) {
        GangsterAi.retreatFromNearestTarget(pGangster, pTarget);
    }

    private static void retreatFromNearestTarget(Gangster pGangster, class_1309 pTarget) {
        class_4095<Gangster> brain = pGangster.method_18868();
        class_1309 $$2 = class_4215.method_24562((class_1309)pGangster, (Optional)brain.method_18904(class_4140.field_22357), (class_1309)pTarget);
        $$2 = class_4215.method_24562((class_1309)pGangster, (Optional)brain.method_18904(class_4140.field_22355), (class_1309)$$2);
        GangsterAi.setAvoidTarget(pGangster, $$2);
    }

    private static void setAvoidTarget(Gangster pGangster, class_1309 pTarget) {
        pGangster.method_18868().method_18875(class_4140.field_22355);
        pGangster.method_18868().method_18875(class_4140.field_18445);
        pGangster.method_18868().method_24525(class_4140.field_22357, (Object)pTarget, (long)RETREAT_DURATION.method_35008(pGangster.method_37908().field_9229));
    }

    private static Optional<? extends class_1309> findNearestValidAttackTarget(Gangster gangster) {
        Optional living = gangster.method_18868().method_18904(class_4140.field_18442);
        Optional attackable = living.flatMap(m -> m.method_38975(class_1309::method_5805));
        if (attackable.isPresent() && !(attackable.get() instanceof Gangster)) {
            return !GangsterAi.isPacified(gangster) && !GangsterAi.isBreeding(gangster) ? attackable : Optional.empty();
        }
        return Optional.empty();
    }

    static boolean isPosNearNearestRepellent(Gangster pGangster, class_2338 pPos) {
        Optional optional = pGangster.method_18868().method_18904(class_4140.field_22474);
        return optional.isPresent() && ((class_2338)optional.get()).method_19771((class_2382)pPos, 8.0);
    }

    private static boolean wantsToStopFleeing(Gangster p_34618_) {
        return p_34618_.isAdult() && !GangsterAi.piglinsOutnumberHoglins(p_34618_);
    }

    private static boolean piglinsOutnumberHoglins(Gangster pGangster) {
        int j;
        if (pGangster.method_6109()) {
            return false;
        }
        int i = pGangster.method_18868().method_18904(class_4140.field_22347).orElse(0);
        return i > (j = pGangster.method_18868().method_18904(class_4140.field_22348).orElse(0) + 1);
    }

    protected static void wasHurtBy(Gangster pGangster, class_1309 pLivingEntity) {
        class_4095<Gangster> brain = pGangster.method_18868();
        brain.method_18875(class_4140.field_22353);
        brain.method_18875(class_4140.field_18448);
        if (pGangster.method_6109()) {
            GangsterAi.retreatFromNearestTarget(pGangster, pLivingEntity);
        } else {
            GangsterAi.maybeRetaliate(pGangster, pLivingEntity);
        }
    }

    private static void maybeRetaliate(Gangster pGangster, class_1309 pLivingEntity) {
        if (!(pGangster.method_18868().method_18906(class_4168.field_22399) && pLivingEntity.method_5864() == class_1299.field_22281 || pLivingEntity.method_5864() == class_1299.field_21973 || class_4215.method_24558((class_1309)pGangster, (class_1309)pLivingEntity, (double)4.0) || !class_4148.method_36982((class_1309)pGangster, (class_1309)pLivingEntity))) {
            GangsterAi.setAttackTarget(pGangster, pLivingEntity);
            GangsterAi.broadcastAttackTarget(pGangster, pLivingEntity);
        }
    }

    private static void setAttackTarget(Gangster pGangster, class_1309 pTarget) {
        class_4095<Gangster> brain = pGangster.method_18868();
        brain.method_18875(class_4140.field_19293);
        brain.method_18875(class_4140.field_18448);
        brain.method_24525(class_4140.field_22355, (Object)pTarget, 200L);
    }

    private static void broadcastAttackTarget(Gangster pGangster, class_1309 pTarget) {
        GangsterAi.setAttackTargetIfCloserThanCurrent(pGangster, pTarget);
    }

    private static void setAttackTargetIfCloserThanCurrent(Gangster pGangster, class_1309 pTarget) {
        if (!GangsterAi.isPacified(pGangster)) {
            Optional optional = pGangster.method_18868().method_18904(class_4140.field_22355);
            class_1309 livingentity = class_4215.method_24562((class_1309)pGangster, (Optional)optional, (class_1309)pTarget);
            GangsterAi.setAttackTarget(pGangster, livingentity);
        }
    }

    public static Optional<class_3414> getSoundForCurrentActivity(Gangster pGangster) {
        return pGangster.method_18868().method_24538().map(p_34600_ -> GangsterAi.getSoundForActivity(pGangster, p_34600_));
    }

    private static class_3414 getSoundForActivity(Gangster pGangster, class_4168 pActivity) {
        if (pActivity != class_4168.field_22399) {
            if (pActivity == class_4168.field_22396) {
                return class_3417.field_22257;
            }
            return GangsterAi.isNearRepellent(pGangster) ? class_3417.field_22261 : class_3417.field_22256;
        }
        return class_3417.field_22261;
    }

    private static boolean isNearRepellent(Gangster pGangster) {
        return pGangster.method_18868().method_18896(class_4140.field_22474);
    }

    private static boolean isBreeding(Gangster p_34638_) {
        return p_34638_.method_18868().method_18896(class_4140.field_18448);
    }

    protected static boolean isPacified(Gangster pGangster) {
        return pGangster.method_18868().method_18896(class_4140.field_22353);
    }
}

