/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.resource;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_3272;
import net.minecraft.class_5352;
import net.minecraft.class_7367;
import net.minecraft.class_7662;
import net.minecraft.class_9224;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ResourceWrapper
implements class_3262 {
    public static final ResourceWrapper INSTANCE = new ResourceWrapper();
    private static final String PACK_ID = "lmmlresources";
    private static final class_3272 METADATA = new class_3272((class_2561)class_2561.method_43471((String)"pack.description.lmmlresources"), class_155.method_16673().method_48017(class_3264.field_14188), Optional.empty());
    private static final HashMap<class_2960, Resource> PATHS = Maps.newHashMap();
    private static final class_5352 RESOURCE_PACK_SOURCE = new class_5352(){

        public class_2561 method_45282(class_2561 packName) {
            return class_2561.method_43469((String)"pack.nameAndSource", (Object[])new Object[]{packName, class_2561.method_43471((String)"pack.source.lmmlresources")});
        }

        public boolean method_45279() {
            return true;
        }
    };
    private static final class_9224 PACK_INFO = new class_9224("lmmlresources", (class_2561)class_2561.method_43471((String)"pack.name.lmmlresources"), class_5352.field_25348, Optional.empty());

    @Nullable
    public class_7367<InputStream> method_14410(String ... segments) {
        return null;
    }

    @Nullable
    public class_7367<InputStream> method_14405(class_3264 type, class_2960 id) {
        Resource resource = PATHS.get(id);
        System.out.println("Trying to load resource: " + String.valueOf(id));
        if (resource == null) {
            System.out.println("Resource not found: " + String.valueOf(id));
            return null;
        }
        return resource::getInputStream;
    }

    public void method_14408(class_3264 type, String namespace, String prefix, class_3262.class_7664 consumer) {
        PATHS.entrySet().stream().filter(entry -> ((class_2960)entry.getKey()).method_12836().equals(namespace)).filter(entry -> ((class_2960)entry.getKey()).method_12832().startsWith(prefix)).forEach(e -> consumer.accept((Object)((class_2960)e.getKey()), () -> ((Resource)e.getValue()).getInputStream()));
    }

    public Set<String> method_14406(class_3264 type) {
        return PATHS.keySet().stream().map(class_2960::method_12836).collect(Collectors.toSet());
    }

    public <T> T method_14407(class_3270<T> metaReader) {
        return (T)class_7662.method_45174((class_3270)class_3272.field_14202, (Object)METADATA).method_45173(metaReader);
    }

    public class_9224 method_56926() {
        return PACK_INFO;
    }

    public String method_14409() {
        return PACK_ID;
    }

    public void close() {
    }

    public static void addResourcePath(class_2960 resourcePath, String path, Path homePath, boolean isArchive) {
        PATHS.put(resourcePath, new Resource(path, homePath, isArchive));
    }

    public record Resource(String path, Path homePath, boolean isArchive) {
        public InputStream getInputStream() throws IOException {
            if (this.isArchive) {
                String resourcePath = this.homePath.toString();
                ZipFile zipfile = new ZipFile(resourcePath);
                ZipEntry zipentry = zipfile.getEntry(this.path);
                if (zipentry == null) {
                    zipfile.close();
                    throw new NoSuchFileException(this.path);
                }
                return zipfile.getInputStream(zipentry);
            }
            return Files.newInputStream(Paths.get(this.homePath.toString(), this.path), new OpenOption[0]);
        }
    }
}

