/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.util;

import com.yzqdev.mod.jeanmod.JeanMod;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1548;
import net.minecraft.class_1621;
import net.minecraft.class_1646;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3218;

public class GlobalHelper {
    public static boolean isDev() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    public static boolean isClient() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    public static boolean onWorldJoin(class_1937 world, class_1297 entity) {
        if (world.field_9236) {
            return true;
        }
        class_3218 serverworld = (class_3218)world;
        if (entity instanceof class_1621 || entity instanceof class_1548) {
            return !serverworld.method_8503().method_27728().method_45555();
        }
        return true;
    }

    public static boolean isVillagerInventoryEmpty(class_1646 villager) {
        for (int i = 0; i < villager.method_35199().method_5439(); ++i) {
            if (villager.method_35199().method_5438(i).method_7960()) continue;
            return false;
        }
        return true;
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)"jean", (String)path);
    }

    public static class_2960 res(String name) {
        return class_2960.method_60655((String)"jean", (String)name);
    }

    public static class_2960 prefix(String name) {
        return class_2960.method_60655((String)"jean", (String)name.toLowerCase(Locale.ROOT));
    }

    public static void copyFolder(Path source, Path target) throws IOException {
        if (!Files.isDirectory(source, new LinkOption[0])) {
            JeanMod.LOGGER.error("Source must be a directory");
        }
        if (!Files.exists(target, new LinkOption[0])) {
            Files.createDirectories(target, new FileAttribute[0]);
        }
        Files.walk(source, new FileVisitOption[0]).forEach(srcPath -> {
            try {
                String relativePath = source.relativize((Path)srcPath).toString();
                Path destPath = target.resolve(relativePath);
                System.out.println("Copying: " + String.valueOf(srcPath) + " -> " + String.valueOf(destPath));
                if (Files.isDirectory(srcPath, new LinkOption[0])) {
                    Files.createDirectories(destPath, new FileAttribute[0]);
                } else {
                    Files.copy(srcPath, destPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                }
            }
            catch (IOException e) {
                JeanMod.LOGGER.error("Failed to copy: " + String.valueOf(srcPath), (Throwable)e);
            }
        });
    }

    public static void copySounds() {
        try {
            Path soundFolder = FabricLoader.getInstance().getGameDir().resolve(JeanMod.soundsFolderName);
            if (!Files.exists(soundFolder, new LinkOption[0])) {
                Files.createDirectory(soundFolder, new FileAttribute[0]);
            }
            Path from = Path.of(GlobalHelper.class.getClassLoader().getResource(JeanMod.soundsFolderName).toURI());
            GlobalHelper.copyFolder(from, soundFolder);
        }
        catch (Exception e) {
            JeanMod.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }
}

