/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.network;

import com.yzqdev.mod.jeanmod.network.LMSoundPacket;
import com.yzqdev.mod.jeanmod.network.SyncSoundPackPacket;
import com.yzqdev.mod.jeanmod.network.packet.CommandItemMessage;
import com.yzqdev.mod.jeanmod.network.packet.PlayMaidSoundMessage;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;

public class Networking {
    public static final Networking INSTANCE = new Networking();

    public void init() {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            this.clientInit();
        }
        this.serverInit();
    }

    @Environment(value=EnvType.CLIENT)
    private void clientInit() {
        PayloadTypeRegistry.playS2C().register(SyncSoundPackPacket.ID, SyncSoundPackPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(LMSoundPacket.ID, LMSoundPacket.CODEC);
        ClientPlayNetworking.registerGlobalReceiver(SyncSoundPackPacket.ID, SyncSoundPackPacket::receiveS2CPacket);
        ClientPlayNetworking.registerGlobalReceiver(LMSoundPacket.ID, LMSoundPacket::receiveS2CPacket);
        PayloadTypeRegistry.playS2C().register(PlayMaidSoundMessage.ID, PlayMaidSoundMessage.CODEC);
        ClientPlayNetworking.registerGlobalReceiver(PlayMaidSoundMessage.ID, PlayMaidSoundMessage::getPacket);
    }

    private void serverInit() {
        PayloadTypeRegistry.playC2S().register(SyncSoundPackPacket.ID, SyncSoundPackPacket.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(SyncSoundPackPacket.ID, SyncSoundPackPacket::receiveC2SPacket);
        PayloadTypeRegistry.playC2S().register(CommandItemMessage.TYPE, CommandItemMessage.STREAM_CODEC);
        ServerPlayNetworking.registerGlobalReceiver(CommandItemMessage.TYPE, CommandItemMessage::handleServer);
    }
}

