/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.resource;

import com.yzqdev.mod.jeanmod.JeanMod;
import com.yzqdev.mod.jeanmod.resource.LMLoader;
import com.yzqdev.mod.jeanmod.resource.LMSoundManager;
import com.yzqdev.mod.jeanmod.resource.ResourceHelper;
import com.yzqdev.mod.jeanmod.resource.ResourceWrapper;
import java.io.InputStream;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Environment(value=EnvType.CLIENT)
public class LMSoundLoader
implements LMLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private final LMSoundManager soundManager;

    public LMSoundLoader(LMSoundManager soundManager) {
        this.soundManager = soundManager;
    }

    @Override
    public boolean canLoad(String path, Path folderPath, InputStream inputStream, boolean isArchive) {
        return path.endsWith(".ogg") && ResourceHelper.getParentFolderNameNew(path, isArchive).isPresent();
    }

    @Override
    public void load(String path, Path folderPath, InputStream inputStream, boolean isArchive) {
        String packName = ResourceHelper.getFirstParentName(path, folderPath, isArchive).orElse("");
        String parent = ResourceHelper.getParentFolderNameNew(path, isArchive).orElse("");
        String fileName = ResourceHelper.getFileName(path, isArchive);
        class_2960 location = ResourceHelper.getLocation("sounds", packName, fileName);
        fileName = ResourceHelper.removeExtension(fileName);
        fileName = ResourceHelper.removeNameLastIndex(fileName);
        this.soundManager.addSound(packName, parent, fileName, location);
        ResourceWrapper.addResourcePath(location, path, folderPath, isArchive);
        if (JeanMod.getConfig().isDebugMode()) {
            LOGGER.debug("Loaded Sound : {} : {}", (Object)packName, (Object)fileName);
        }
    }
}

