/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.sound;

import com.yzqdev.mod.jeanmod.entity.maid.Maid;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_5819;

public class SoundUtil {
    private static final long MORNING_START = 0L;
    private static final long MORNING_END = 3000L;
    private static final long EVENING_START = 12000L;
    private static final long EVENING_END = 15000L;

    public static String environmentSound(Maid maid, float probability) {
        class_1937 world = maid.method_37908();
        class_5819 rand = maid.method_59922();
        class_2338 pos = maid.method_24515();
        long dayTime = world.method_8532();
        class_1959 biome = (class_1959)world.method_23753(pos).comp_349();
        if (rand.method_43057() < probability && 0L < dayTime && dayTime < 3000L) {
            return "maid.environment.morning";
        }
        if (rand.method_43057() < probability && 12000L < dayTime && dayTime < 15000L) {
            return "maid.environment.night";
        }
        if (rand.method_43057() < probability && world.method_8419() && SoundUtil.isRainBiome(biome, pos)) {
            return "maid.environment.rain";
        }
        if (rand.method_43057() < probability && world.method_8419() && SoundUtil.isSnowyBiome(biome, pos)) {
            return "maid.environment.snow";
        }
        if (rand.method_43057() < probability && biome.method_33599(pos)) {
            return "maid.environment.cold";
        }
        if (rand.method_43057() < probability && SoundUtil.shouldSnowGolemBurn(biome, pos)) {
            return "maid.environment.hot";
        }
        return "maid.mode.idle";
    }

    public static String attackSound(Maid maid, float probability) {
        float rand = maid.method_59922().method_43057();
        if (rand < probability) {
            if (rand > probability / 2.0f) {
                return "maid.ai.attack";
            }
            return "maid.ai.find_target";
        }
        return "maid.mode.idle";
    }

    public static boolean isRainBiome(class_1959 biome, class_2338 pos) {
        return biome.method_48162(pos) == class_1959.class_1963.field_9382 && !SoundUtil.shouldSnowGolemBurn(biome, pos);
    }

    public static boolean isSnowyBiome(class_1959 biome, class_2338 pos) {
        return biome.method_48162(pos) == class_1959.class_1963.field_9383;
    }

    private static boolean shouldSnowGolemBurn(class_1959 biome, class_2338 pos) {
        return biome.method_21740(pos) > 1.0f;
    }
}

