/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod;

import com.yzqdev.mod.jeanmod.LMMLConfig;
import com.yzqdev.mod.jeanmod.entity.ModEntities;
import com.yzqdev.mod.jeanmod.event.ServerLevelEvents;
import com.yzqdev.mod.jeanmod.gui.ModMenus;
import com.yzqdev.mod.jeanmod.item.ModItemGroups;
import com.yzqdev.mod.jeanmod.item.ModItems;
import com.yzqdev.mod.jeanmod.network.Networking;
import com.yzqdev.mod.jeanmod.resource.LMFileLoader;
import com.yzqdev.mod.jeanmod.resource.LMSoundLoader;
import com.yzqdev.mod.jeanmod.resource.LMSoundManager;
import com.yzqdev.mod.jeanmod.sound.ModSoundEvents;
import com.yzqdev.mod.jeanmod.util.ModSensorTypes;
import com.yzqdev.mod.jeanmod.worldgen.WorldModification;
import java.nio.file.Paths;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JeanMod
implements ModInitializer {
    public static final String MOD_ID = "jean";
    public static String soundsFolderName = "maidSounds";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"jean");
    private static ConfigHolder<LMMLConfig> CONFIG_HOLDER;

    public void onInitialize() {
        AutoConfig.register(LMMLConfig.class, Toml4jConfigSerializer::new);
        CONFIG_HOLDER = AutoConfig.getConfigHolder(LMMLConfig.class);
        this.initRegister();
        Networking.INSTANCE.init();
        JeanMod.initSoundPack();
        LOGGER.info("Hello Fabric world!");
    }

    public static LMMLConfig getConfig() {
        return (LMMLConfig)CONFIG_HOLDER.getConfig();
    }

    void initRegister() {
        ModItemGroups.init();
        ModSensorTypes.initialize();
        ModEntities.init();
        ModEntities.registerEntityAttributes(FabricDefaultAttributeRegistry::register);
        ModItems.init();
        ModMenus.init();
        ModSoundEvents.init();
        ServerLevelEvents.initialize();
        WorldModification.addSpawns();
    }

    public static void initSoundPack() {
        JeanMod.initFileLoader();
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            JeanMod.initSoundLoader();
        }
        LMFileLoader.INSTANCE.load();
    }

    public static void initFileLoader() {
        LMFileLoader fileLoader = LMFileLoader.INSTANCE;
        fileLoader.addLoadFolderPath(Paths.get(FabricLoader.getInstance().getGameDir().toString(), soundsFolderName));
    }

    @Environment(value=EnvType.CLIENT)
    public static void initSoundLoader() {
        LMFileLoader.INSTANCE.addLoader(new LMSoundLoader(LMSoundManager.INSTANCE));
    }
}

