/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.entity.gangster;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import com.yzqdev.mod.jeanmod.entity.gangster.GangsterAi;
import com.yzqdev.mod.jeanmod.entity.gangster.GangsterHit;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1429;
import net.minecraft.class_1569;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4209;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Gangster
extends class_1429
implements class_1569,
GangsterHit,
GeoEntity {
    protected static final ImmutableList<? extends class_4149<? extends class_4148<? super Gangster>>> SENSOR_TYPES = ImmutableList.of((Object)class_4149.field_18466, (Object)class_4149.field_18467, (Object)class_4149.field_25362);
    protected static final ImmutableList<? extends class_4140<?>> MEMORY_TYPES = ImmutableList.of((Object)class_4140.field_18448, (Object)class_4140.field_18441, (Object)class_4140.field_18442, (Object)class_4140.field_18444, (Object)class_4140.field_22354, (Object)class_4140.field_18446, (Object)class_4140.field_18445, (Object)class_4140.field_19293, (Object)class_4140.field_18449, (Object)class_4140.field_22355, (Object)class_4140.field_22475, (Object)class_4140.field_22345, (Object[])new class_4140[]{class_4140.field_22357, class_4140.field_22347, class_4140.field_22348, class_4140.field_22344, class_4140.field_25359, class_4140.field_22474, class_4140.field_22353});
    private static final class_2940<Boolean> DATA_IMMUNE_TO_ZOMBIFICATION = class_2945.method_12791(Gangster.class, (class_2941)class_2943.field_13323);
    private static final float PROBABILITY_OF_SPAWNING_AS_BABY = 0.2f;
    private static final int MAX_HEALTH = 40;
    private static final float MOVEMENT_SPEED_WHEN_FIGHTING = 0.3f;
    private static final int ATTACK_KNOCKBACK = 1;
    private static final float KNOCKBACK_RESISTANCE = 0.6f;
    private static final int ATTACK_DAMAGE = 6;
    private static final float BABY_ATTACK_DAMAGE = 0.5f;
    private static final int CONVERSION_TIME = 300;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int attackAnimationRemainingTicks;
    private int timeInOverworld;
    private boolean cannotBeHunted;

    public Gangster(class_1299<? extends Gangster> pEntityType, class_1937 pLevel) {
        super(pEntityType, pLevel);
        this.field_6194 = 5;
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 40.0).method_26868(class_5134.field_23719, (double)0.3f).method_26868(class_5134.field_23718, (double)0.6f).method_26868(class_5134.field_23722, 1.0).method_26868(class_5134.field_23721, 6.0);
    }

    public static boolean checkHoglinSpawnRules(class_1299<Gangster> pHoglin, class_1936 pLevel, class_3730 pSpawnType, class_2338 pPos, class_5819 pRandom) {
        return !pLevel.method_8320(pPos.method_10074()).method_27852(class_2246.field_10541);
    }

    public static boolean checkGangsterSpawnRules(class_1299<Gangster> gangsterEntityType, class_5425 serverLevelAccessor, class_3730 mobSpawnType, class_2338 blockPos, class_5819 randomSource) {
        return true;
    }

    public boolean method_5931(class_1657 pPlayer) {
        return !this.method_5934();
    }

    public boolean method_6121(class_1297 pEntity) {
        if (!(pEntity instanceof class_1309)) {
            return false;
        }
        this.attackAnimationRemainingTicks = 10;
        this.method_37908().method_8421((class_1297)this, (byte)4);
        this.method_5783(class_3417.field_22258, 1.0f, this.method_6017());
        GangsterAi.onHitTarget(this, (class_1309)pEntity);
        return GangsterHit.hurtAndThrowTarget((class_1309)this, (class_1309)pEntity);
    }

    protected void method_6060(class_1309 pEntity) {
        if (this.isAdult()) {
            GangsterHit.throwTarget((class_1309)this, pEntity);
        }
    }

    public boolean method_5643(class_1282 pSource, float pAmount) {
        this.triggerAnim("attacked_controller", "attacked");
        boolean flag = super.method_5643(pSource, pAmount);
        if (this.method_37908().field_9236) {
            return false;
        }
        if (flag && pSource.method_5529() instanceof class_1309) {
            GangsterAi.wasHurtBy(this, (class_1309)pSource.method_5529());
        }
        return flag;
    }

    protected class_4095.class_5303<Gangster> method_28306() {
        return class_4095.method_28311(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected class_4095<?> method_18867(Dynamic<?> pDynamic) {
        return GangsterAi.makeBrain((class_4095<Gangster>)this.method_28306().method_28335(pDynamic));
    }

    public class_4095<Gangster> method_18868() {
        return super.method_18868();
    }

    protected void method_5958() {
        this.method_37908().method_16107().method_15396("hoglinBrain");
        this.method_18868().method_19542((class_3218)this.method_37908(), (class_1309)this);
        this.method_37908().method_16107().method_15407();
        GangsterAi.updateActivity(this);
    }

    public void method_6007() {
        if (this.attackAnimationRemainingTicks > 0) {
            --this.attackAnimationRemainingTicks;
        }
        super.method_6007();
    }

    protected void method_5619() {
        if (this.method_6109()) {
            this.field_6194 = 3;
            this.method_5996(class_5134.field_23721).method_6192(0.5);
        } else {
            this.field_6194 = 5;
            this.method_5996(class_5134.field_23721).method_6192(6.0);
        }
    }

    @Nullable
    public class_1315 method_5943(class_5425 pLevel, class_1266 pDifficulty, class_3730 pReason, @Nullable class_1315 pSpawnData, @Nullable class_2487 pDataTag) {
        return super.method_5943(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public boolean method_5974(double pDistanceToClosestPlayer) {
        return !this.method_5947();
    }

    public float method_6144(class_2338 pPos, class_4538 pLevel) {
        if (GangsterAi.isPosNearNearestRepellent(this, pPos)) {
            return -1.0f;
        }
        return pLevel.method_8320(pPos.method_10074()).method_27852(class_2246.field_22120) ? 10.0f : 0.0f;
    }

    public double method_5621() {
        return (double)this.method_17682() - (this.method_6109() ? 0.2 : 0.15);
    }

    public class_1269 method_5992(class_1657 pPlayer, class_1268 pHand) {
        class_1269 interactionresult = super.method_5992(pPlayer, pHand);
        if (interactionresult.method_23665()) {
            this.method_5971();
        }
        return interactionresult;
    }

    public void method_5711(byte pId) {
        if (pId == 4) {
            this.attackAnimationRemainingTicks = 10;
            this.method_5783(class_3417.field_22258, 1.0f, this.method_6017());
        } else {
            super.method_5711(pId);
        }
    }

    @Override
    public int getAttackAnimationRemainingTicks() {
        return this.attackAnimationRemainingTicks;
    }

    public boolean method_6054() {
        return true;
    }

    public int method_6110() {
        return this.field_6194;
    }

    public boolean method_6481(class_1799 pStack) {
        return pStack.method_31574(class_1802.field_21987);
    }

    public boolean isAdult() {
        return !this.method_6109();
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_IMMUNE_TO_ZOMBIFICATION, (Object)false);
    }

    public void method_5652(class_2487 pCompound) {
        super.method_5652(pCompound);
        if (this.isImmuneToZombification()) {
            pCompound.method_10556("IsImmuneToZombification", true);
        }
        pCompound.method_10569("TimeInOverworld", this.timeInOverworld);
        if (this.cannotBeHunted) {
            pCompound.method_10556("CannotBeHunted", true);
        }
    }

    public void method_5749(class_2487 pCompound) {
        super.method_5749(pCompound);
        this.setImmuneToZombification(pCompound.method_10577("IsImmuneToZombification"));
        this.timeInOverworld = pCompound.method_10550("TimeInOverworld");
        this.setCannotBeHunted(pCompound.method_10577("CannotBeHunted"));
    }

    private boolean isImmuneToZombification() {
        return (Boolean)this.method_5841().method_12789(DATA_IMMUNE_TO_ZOMBIFICATION);
    }

    public void setImmuneToZombification(boolean pImmuneToZombification) {
        this.method_5841().method_12778(DATA_IMMUNE_TO_ZOMBIFICATION, (Object)pImmuneToZombification);
    }

    private void setCannotBeHunted(boolean pCannotBeHunted) {
        this.cannotBeHunted = pCannotBeHunted;
    }

    public boolean canBeHunted() {
        return this.isAdult() && !this.cannotBeHunted;
    }

    @Nullable
    public class_1296 method_5613(class_3218 pLevel, class_1296 pOtherParent) {
        return null;
    }

    public boolean method_6482() {
        return !GangsterAi.isPacified(this) && super.method_6482();
    }

    public class_3419 method_5634() {
        return class_3419.field_15251;
    }

    protected class_3414 method_5994() {
        return this.method_37908().field_9236 ? null : (class_3414)GangsterAi.getSoundForCurrentActivity(this).orElse(null);
    }

    protected class_3414 method_6011(class_1282 pDamageSource) {
        return class_3417.field_22260;
    }

    protected class_3414 method_6002() {
        return class_3417.field_22259;
    }

    protected class_3414 method_5737() {
        return class_3417.field_14630;
    }

    protected class_3414 method_5625() {
        return class_3417.field_14836;
    }

    protected void method_5712(class_2338 pPos, class_2680 pBlock) {
        this.method_5783(class_3417.field_22262, 0.15f, 1.0f);
    }

    protected void playSoundEvent(class_3414 pSoundEvent) {
        this.method_5783(pSoundEvent, this.method_6107(), this.method_6017());
    }

    protected void method_18409() {
        super.method_18409();
        class_4209.method_19774((class_1309)this);
    }

    private PlayState predicate(AnimationState animationState) {
        if (animationState.isMoving()) {
            animationState.getController().setAnimation(RawAnimation.begin().then("move.walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        animationState.getController().setAnimation(RawAnimation.begin().then("misc.idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    private PlayState attackPredicate(AnimationState state) {
        if (this.field_6252 && state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            state.getController().forceAnimationReset();
            state.getController().setAnimation(RawAnimation.begin().then("attack.strike", Animation.LoopType.PLAY_ONCE));
            this.field_6252 = false;
        }
        return PlayState.CONTINUE;
    }

    private PlayState diePredicate(AnimationState state) {
        if (this.method_29504()) {
            return state.setAndContinue(DefaultAnimations.DIE);
        }
        state.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    private PlayState jumpPredicate(AnimationState state) {
        if (this.method_5799() || this.method_24828() || this.method_5765() || this.field_6235 > 0) {
            return PlayState.STOP;
        }
        state.getController().setAnimation(RawAnimation.begin().then("jump", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 0, this::attackPredicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "jumpController", 0, this::jumpPredicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attacked_controller", event -> PlayState.STOP).triggerableAnim("attacked", RawAnimation.begin().then("attacked", Animation.LoopType.PLAY_ONCE))});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "die", 0, this::diePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

