/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.entity.maid;

import com.google.common.collect.ImmutableMap;
import com.yzqdev.mod.jeanmod.entity.maid.Maid;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_14;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4102;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import org.jetbrains.annotations.Nullable;

public class MaidFollowOwnerTask
extends class_4097<Maid> {
    private static final int MAX_TELEPORT_ATTEMPTS_TIMES = 10;
    private final float speedModifier;
    private final int stopDistance;

    public MaidFollowOwnerTask(float speedModifier, int stopDistance) {
        super((Map)ImmutableMap.of((Object)class_4140.field_18445, (Object)class_4141.field_18458));
        this.speedModifier = speedModifier;
        this.stopDistance = stopDistance;
    }

    protected void start(class_3218 worldIn, Maid maid, long gameTimeIn) {
        class_1309 owner = maid.method_35057();
        int startDistance = (int)maid.method_18413() - 2;
        int minTeleportDistance = startDistance + 4;
        if (this.ownerStateConditions(owner) && !maid.method_24516((class_1297)owner, startDistance)) {
            if (!maid.method_24516((class_1297)owner, minTeleportDistance)) {
                this.teleportToOwner(maid, owner);
            } else if (!this.ownerIsWalkTarget(maid, owner)) {
                class_4215.method_24557((class_1309)maid, (class_1297)owner, (float)this.speedModifier, (int)this.stopDistance);
            }
        }
    }

    private void teleportToOwner(Maid maid, class_1309 owner) {
        class_2338 blockPos = owner.method_24515();
        for (int i = 0; i < 10; ++i) {
            int x = this.randomIntInclusive(maid.method_6051(), -3, 3);
            int y = this.randomIntInclusive(maid.method_6051(), -1, 1);
            int z = this.randomIntInclusive(maid.method_6051(), -3, 3);
            if (!this.maybeTeleportTo(maid, owner, blockPos.method_10263() + x, blockPos.method_10264() + y, blockPos.method_10260() + z)) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(Maid maid, class_1309 owner, int x, int y, int z) {
        if (this.teleportTooClosed(owner, x, z)) {
            return false;
        }
        if (!this.canTeleportTo(maid, new class_2338(x, y, z))) {
            return false;
        }
        maid.method_5808((double)x + 0.5, y, (double)z + 0.5, maid.method_36454(), maid.method_36455());
        maid.method_5942().method_6340();
        maid.method_18868().method_18875(class_4140.field_18445);
        maid.method_18868().method_18875(class_4140.field_18446);
        maid.method_18868().method_18875(class_4140.field_22355);
        maid.method_18868().method_18875(class_4140.field_18449);
        return true;
    }

    private boolean teleportTooClosed(class_1309 owner, int x, int z) {
        return Math.abs((double)x - owner.method_23317()) < 2.0 && Math.abs((double)z - owner.method_23321()) < 2.0;
    }

    private boolean canTeleportTo(Maid maid, class_2338 pos) {
        class_7 pathNodeType = class_14.method_23476((class_1922)maid.method_37908(), (class_2338.class_2339)pos.method_25503());
        if (pathNodeType == class_7.field_12) {
            class_2338 blockPos = pos.method_10059((class_2382)maid.method_24515());
            return maid.method_37908().method_8587((class_1297)maid, maid.method_5829().method_996(blockPos));
        }
        return false;
    }

    private int randomIntInclusive(class_5819 random, int min, int max) {
        return random.method_43048(max - min + 1) + min;
    }

    private boolean ownerStateConditions(@Nullable class_1309 owner) {
        return owner != null && !owner.method_7325() && !owner.method_29504();
    }

    private boolean ownerIsWalkTarget(Maid maid, class_1309 owner) {
        return maid.method_18868().method_18904(class_4140.field_18445).map(target -> {
            if (target.method_19094() instanceof class_4102) {
                return ((class_4102)target.method_19094()).method_35066().equals((Object)owner);
            }
            return false;
        }).orElse(false);
    }
}

