/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.network;

import com.yzqdev.mod.jeanmod.entity.maid.Maid;
import com.yzqdev.mod.jeanmod.resource.PlayerList;
import com.yzqdev.mod.jeanmod.resource.SoundPlayable;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_5455;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.server.MinecraftServer;

public record SyncSoundPackPacket(int entityId, String soundPackName) {
    public static final class_2960 ID = new class_2960("jean", "sync_sound_pack");

    @Environment(value=EnvType.CLIENT)
    public static void sendC2SPacket(class_1297 entity, String soundName) {
        SyncSoundPackPacket passedData = new SyncSoundPackPacket(entity.method_5628(), soundName);
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10814(soundName);
        buf.writeInt(entity.method_5628());
        ClientPlayNetworking.send((class_2960)ID, (class_2540)buf);
    }

    public static void sendS2CPacket(class_1297 entity, String soundName, class_5455 access) {
        SyncSoundPackPacket passedData = new SyncSoundPackPacket(entity.method_5628(), soundName);
        Collection<class_3222> players = PlayerList.tracking(entity);
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10814(soundName);
        buf.writeInt(entity.method_5628());
        for (class_3222 p : players) {
            ServerPlayNetworking.send((class_3222)p, (class_2960)ID, (class_2540)buf);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void receiveS2CPacket(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        int entityId = buf.readInt();
        String soundPackName = buf.method_19772();
        client.execute(() -> SyncSoundPackPacket.applyMultiModelClient(entityId, soundPackName));
    }

    @Environment(value=EnvType.CLIENT)
    public static void applyMultiModelClient(int entityId, String soundPackName) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        class_1297 entity = world.method_8469(entityId);
        if (!(entity instanceof SoundPlayable)) {
            return;
        }
        SoundPlayable soundPlayable = (SoundPlayable)entity;
    }

    public static void receiveC2SPacket(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        int entityId = buf.readInt();
        String soundPackName = buf.method_19772();
        server.execute(() -> {
            class_1297 entity = player.method_37908().method_8469(entityId);
            if (entity instanceof Maid) {
                Maid maid = (Maid)entity;
                maid.setSoundpack(soundPackName);
            }
        });
    }
}

