/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.resource;

import com.yzqdev.mod.jeanmod.resource.LMLoader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import net.minecraft.class_156;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LMFileLoader {
    public static final LMFileLoader INSTANCE = new LMFileLoader();
    private static final Logger LOGGER = LogManager.getLogger();
    private final ArrayList<LMLoader> loaders = new ArrayList();
    private final ArrayList<Path> folderPaths = new ArrayList();

    public void addLoader(LMLoader loader) {
        this.loaders.add(loader);
    }

    public void addLoadFolderPath(Path path) {
        if (Files.notExists(path, new LinkOption[0])) {
            try {
                Files.createDirectory(path, new FileAttribute[0]);
            }
            catch (Exception e) {
                LOGGER.error((Object)e);
                return;
            }
        }
        this.folderPaths.add(path);
    }

    public ArrayList<Path> getFolderPaths() {
        return this.folderPaths;
    }

    public void load() {
        long start = System.nanoTime();
        LOGGER.info("LMML Loading start");
        this.folderPaths.forEach(folderPath -> {
            try {
                if (Files.notExists(folderPath, new LinkOption[0])) {
                    Files.createDirectory(folderPath, new FileAttribute[0]);
                }
                Stream<Path> stream = Files.walk(folderPath, new FileVisitOption[0]);
                stream.filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> this.fileLoad((Path)folderPath, (Path)path));
                stream.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)e);
            }
        });
        long end = System.nanoTime();
        LOGGER.info("Loading end : {}ms", (Object)((double)(end - start) / 1000000.0));
    }

    private void fileLoad(Path folderPath, Path path) {
        if (this.isArchive(path)) {
            this.loadArchive(folderPath, path);
        } else {
            this.loadFile(folderPath, path);
        }
    }

    public void loadArchive(Path folderPath, Path path) {
        if (!this.loadArchive(folderPath, path, StandardCharsets.UTF_8) && class_156.method_668() == class_156.class_158.field_1133) {
            LOGGER.info("\u8def\u5f84 : {}", (Object)path);
            if (this.loadArchive(folderPath, path, Charset.forName("MS932"))) {
                LOGGER.info("\u6210\u529f\u3002");
            } else {
                LOGGER.error("\u5931\u8d25\u4e86\u3002");
            }
        }
    }

    private boolean loadArchive(Path folderPath, Path path, Charset charset) {
        boolean result = true;
        try (ZipInputStream zipStream = new ZipInputStream(Files.newInputStream(path, new OpenOption[0]), charset);){
            ZipEntry entry;
            while ((entry = zipStream.getNextEntry()) != null) {
                this.loaders.stream().filter(loader -> loader.canLoad(entry.getName(), path, zipStream, true)).forEach(loader -> loader.load(entry.getName(), path, zipStream, true));
            }
        }
        catch (ZipException e) {
            LOGGER.error("Zip\u306e\u8aad\u307f\u8fbc\u307f\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3002\u30d5\u30a1\u30a4\u30eb\u540d\u306b\u65e5\u672c\u8a9e\u306a\u3069\u304c\u5165\u3063\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002Error while loading Zip, possibly due to Japanese characters in the file name. : {}", (Object)path);
            result = false;
        }
        catch (IllegalArgumentException e) {
            if (e.getCause() instanceof MalformedInputException) {
                LOGGER.error("Zip\u306e\u8aad\u307f\u8fbc\u307f\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3002Zip\u5185\u306e\u30d5\u30a1\u30a4\u30eb\u540d\u306b\u65e5\u672c\u8a9e\u306a\u3069\u304c\u5165\u3063\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002Error while loading Zip, possibly due to Japanese characters in the file name in the Zip. : {}", (Object)path);
            } else {
                LOGGER.error("\u4e0d\u660e\u306a\u30a8\u30e9\u30fc\u306b\u3088\u308aZip\u304c\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3002Unknown error prevents Zip from loading. : {}", (Object)path);
            }
            result = false;
        }
        catch (Exception e) {
            LOGGER.error("\u4e0d\u660e\u306a\u30a8\u30e9\u30fc\u306b\u3088\u308aZip\u304c\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3002Unknown error prevents Zip from loading. : {}", (Object)path);
            result = false;
        }
        return result;
    }

    public void loadFile(Path folderPath, Path path) {
        String relPath = path.toString().replace(folderPath.toString(), "");
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            this.loaders.stream().filter(loader -> loader.canLoad(relPath, folderPath, inputStream, false)).forEach(loader -> loader.load(relPath, folderPath, inputStream, false));
        }
        catch (Exception e) {
            LOGGER.error("Error! : {} : {}", (Object)e.getMessage(), (Object)path);
        }
    }

    public boolean isArchive(Path path) {
        return path.toString().endsWith("zip") || path.toString().endsWith("jar");
    }
}

