/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.resource.screen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.yzqdev.mod.jeanmod.resource.screen.GUIElement;
import com.yzqdev.mod.jeanmod.resource.screen.ListGUIElement;
import com.yzqdev.mod.jeanmod.resource.screen.MarginedClickable;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_332;
import net.minecraft.class_3532;

public class ListGUI<T extends GUIElement>
extends GUIElement {
    protected final MarginedClickable selectBox = new MarginedClickable(4);
    protected final int widthStack;
    protected final int heightStack;
    protected final int elementW;
    protected final int elementH;
    protected final ImmutableList<T> elements;
    protected int scroll = 0;
    protected int selectElem = -1;

    public ListGUI(int x, int y, int widthStack, int heightStack, int elementW, int elementH, Collection<T> elements) {
        super(widthStack * elementW, heightStack * elementH);
        this.x = x;
        this.y = y;
        this.widthStack = widthStack;
        this.heightStack = heightStack;
        this.elementW = elementW;
        this.elementH = elementH;
        this.elements = ImmutableList.copyOf(elements);
    }

    public int size() {
        return this.elements.size();
    }

    public void setScroll(int scroll) {
        this.scroll = scroll;
        this.scroll = class_3532.method_15340((int)this.scroll, (int)0, (int)(this.size() / this.widthStack - 1));
    }

    public int getScroll() {
        return this.scroll;
    }

    public List<T> getAllElements() {
        return Lists.newArrayList(this.elements);
    }

    public Optional<T> getSelectElement() {
        if (this.checkElementsBounds(this.selectElem)) {
            return Optional.of((GUIElement)this.elements.get(this.selectElem));
        }
        return Optional.empty();
    }

    protected Optional<T> getElement(double mouseX, double mouseY) {
        int index = this.getIndex(mouseX, mouseY);
        if (this.checkElementsBounds(index)) {
            return Optional.of((GUIElement)this.elements.get(index));
        }
        return Optional.empty();
    }

    protected double getElementX(double mouseX) {
        return (mouseX - (double)this.x) % (double)this.elementW;
    }

    protected double getElementY(double mouseY) {
        return (mouseY - (double)this.y) % (double)this.elementH;
    }

    protected int getIndex(double mouseX, double mouseY) {
        if ((double)this.x <= mouseX && mouseX < (double)(this.x + this.elementW * this.widthStack) && (double)this.y <= mouseY && mouseY < (double)(this.y + this.elementH * this.heightStack)) {
            int xIndex = class_3532.method_15375((float)((float)(mouseX - (double)this.x) / (float)this.elementW));
            int yIndex = class_3532.method_15375((float)((float)(mouseY - (double)this.y) / (float)this.elementH));
            int index = this.scroll * this.widthStack + yIndex * this.widthStack + xIndex;
            if (this.checkElementsBounds(index)) {
                return index;
            }
        }
        return -1;
    }

    protected boolean checkElementsBounds(int index) {
        return 0 <= index && index < this.elements.size();
    }

    protected boolean isRenderingElement(int index) {
        return this.scroll * this.widthStack <= index && index < this.scroll * this.widthStack + this.widthStack * this.heightStack;
    }

    protected int getElementXIndex(int index) {
        return index % this.widthStack;
    }

    protected int getElementYIndex(int index) {
        return index / this.widthStack - this.scroll;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        for (int i = 0; i < this.widthStack * this.heightStack; ++i) {
            int xIndex = i % this.widthStack;
            int yIndex = i / this.widthStack;
            int x = this.x + this.elementW * xIndex;
            int y = this.y + this.elementH * yIndex;
            int index = this.scroll * this.widthStack + yIndex * this.widthStack + xIndex;
            if (!this.checkElementsBounds(index)) continue;
            GUIElement elem = (GUIElement)this.elements.get(index);
            elem.setPos(x, y);
            elem.method_25394(context, mouseX, mouseY, delta);
        }
    }

    public void method_16014(double mouseX, double mouseY) {
        Optional<T> e = this.getElement(mouseX, mouseY);
        if (e.isPresent()) {
            GUIElement element = (GUIElement)e.get();
            element.method_16014(this.getElementX(mouseX), this.getElementY(mouseY));
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        Optional<T> e;
        if (button == 0) {
            this.selectBox.click(mouseX, mouseY);
        }
        if ((e = this.getElement(mouseX, mouseY)).isPresent()) {
            GUIElement element = (GUIElement)e.get();
            return element.method_25402(this.getElementX(mouseX), this.getElementY(mouseY), button);
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        Optional<T> e = this.getElement(mouseX, mouseY);
        if (e.isPresent()) {
            int index;
            if (button == 0 && this.selectBox.release(mouseX, mouseY) && this.checkElementsBounds(index = this.getIndex(mouseX, mouseY))) {
                GUIElement prev;
                if (this.selectElem != index && this.checkElementsBounds(this.selectElem) && (prev = (GUIElement)this.elements.get(this.selectElem)) instanceof ListGUIElement) {
                    ((ListGUIElement)((Object)prev)).setSelected(false);
                }
                this.selectElem = index;
                GUIElement now = (GUIElement)this.elements.get(this.selectElem);
                if (now instanceof ListGUIElement) {
                    ((ListGUIElement)((Object)now)).setSelected(true);
                }
            }
            GUIElement element = (GUIElement)e.get();
            return element.method_25406(this.getElementX(mouseX), this.getElementY(mouseY), button);
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        Optional<T> e = this.getElement(mouseX, mouseY);
        if (e.isPresent()) {
            GUIElement element = (GUIElement)e.get();
            return element.method_25403(this.getElementX(mouseX), this.getElementY(mouseY), button, deltaX, deltaY);
        }
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        return super.method_25400(chr, modifiers);
    }

    public boolean method_25405(double mouseX, double mouseY) {
        Optional<T> e = this.getElement(mouseX, mouseY);
        if (e.isPresent()) {
            GUIElement element = (GUIElement)e.get();
            return element.method_25405(this.getElementX(mouseX), this.getElementY(mouseY));
        }
        return false;
    }
}

