/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.sound;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.yzqdev.mod.jeanmod.JeanMod;
import com.yzqdev.mod.jeanmod.sound.CustomPackLoader;
import com.yzqdev.mod.jeanmod.sound.DefaultPackConstant;
import com.yzqdev.mod.jeanmod.sound.ModSoundEvents;
import com.yzqdev.mod.jeanmod.sound.data.SoundCache;
import com.yzqdev.mod.jeanmod.sound.data.SoundData;
import com.yzqdev.mod.jeanmod.sound.pojo.SoundPackInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_4228;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.NotNull;

public class CustomSoundLoader {
    public static final Map<String, SoundCache> CACHE = Maps.newLinkedHashMap();
    private static final Pattern FILENAME_REG = Pattern.compile("^\\d*\\.ogg$");
    private static final Marker MARKER = MarkerManager.getMarker((String)"CustomSoundLoader");
    private static final String JSON_FILE_NAME = "maid_sound.json";
    public static final Path CONFIG_FOLDER = Paths.get(class_310.method_1551().field_1697.toURI()).resolve("config").resolve("jean");
    public static final Path SOUND_FOLDER = CONFIG_FOLDER.resolve("sounds");

    public static void clear() {
        CACHE.clear();
    }

    public static SoundCache getSoundCache(String id) {
        return CACHE.get(id);
    }

    public static void sortSoundPack() {
        LinkedHashMap sortPacks = Maps.newLinkedHashMap();
        for (String id2 : DefaultPackConstant.SOUND_SORT) {
            if (!CACHE.containsKey(id2)) continue;
            sortPacks.put(id2, CACHE.get(id2));
        }
        CACHE.keySet().stream().filter(id -> !DefaultPackConstant.SOUND_SORT.contains(id)).sorted(String::compareTo).forEach(key -> sortPacks.put(key, CACHE.get(key)));
        CACHE.clear();
        CACHE.putAll(sortPacks);
    }

    public static void loadSoundPack(Path rootPath, String id) {
        File file = rootPath.resolve("assets").resolve(id).resolve(JSON_FILE_NAME).toFile();
        if (!file.isFile()) {
            return;
        }
        JeanMod.LOGGER.debug("Loading {} sound pack: ", (Object)id);
        try (InputStream stream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            SoundPackInfo info = (SoundPackInfo)CustomPackLoader.GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), new TypeToken<SoundPackInfo>(){}.getType());
            info.decorate();
            Path soundsFolder = rootPath.resolve("assets").resolve(id).resolve("sounds").resolve("maid");
            SoundCache soundCache = new SoundCache(CustomSoundLoader.loadSoundEvent(soundsFolder));
            CACHE.put(id, soundCache);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JsonSyntaxException e) {
            JeanMod.LOGGER.warn("Fail to parse sound pack in id {}", (Object)id);
            e.printStackTrace();
        }
        JeanMod.LOGGER.debug("Loaded {} sound pack.", (Object)id);
    }

    private static Map<class_2960, List<SoundData>> loadSoundEvent(Path rootPath) {
        LinkedHashMap buffers = Maps.newLinkedHashMap();
        buffers.put(ModSoundEvents.MAID_IDLE.method_14833(), CustomSoundLoader.loadSounds(rootPath.resolve("mode"), "idle"));
        return buffers;
    }

    private static List<SoundData> loadSounds(Path rootPath, String fileName) {
        ArrayList sounds = Lists.newArrayList();
        File[] files = rootPath.toFile().listFiles((dir, name) -> CustomSoundLoader.checkFileName(fileName, name));
        if (files == null) {
            return sounds;
        }
        for (File file : files) {
            if (!file.isFile()) continue;
            try (InputStream stream = Files.newInputStream(file.toPath(), new OpenOption[0]);
                 class_4228 audioStream = new class_4228(stream);){
                ByteBuffer bytebuffer = audioStream.method_19721();
                sounds.add(new SoundData(bytebuffer, audioStream.method_19719()));
                JeanMod.LOGGER.debug("sound: {}", (Object)file.getName());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sounds;
    }

    private static void reuseSounds(Map<class_2960, List<SoundData>> buffers, class_3414 from, class_3414 to) {
        List<SoundData> fromBuffers = buffers.get(from.method_14833());
        buffers.get(to.method_14833()).addAll(fromBuffers);
    }

    private static boolean checkFileName(String patterString, String rawString) {
        if (rawString.startsWith(patterString)) {
            String substring = rawString.substring(patterString.length());
            Matcher matcher = FILENAME_REG.matcher(substring);
            return matcher.matches();
        }
        return false;
    }

    public static void loadSoundPack(ZipFile zipFile, String id) {
        ZipEntry entry = zipFile.getEntry(String.format("assets/%s/%s", id, JSON_FILE_NAME));
        if (entry == null) {
            return;
        }
        JeanMod.LOGGER.debug("Loading {} sound pack: ", (Object)id);
        try (InputStream stream = zipFile.getInputStream(entry);){
            SoundPackInfo info = (SoundPackInfo)CustomPackLoader.GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), new TypeToken<SoundPackInfo>(){}.getType());
            info.decorate();
            SoundCache soundCache = new SoundCache(CustomSoundLoader.loadSoundEvent(zipFile, id));
            CACHE.put(id, soundCache);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JsonSyntaxException e) {
            JeanMod.LOGGER.warn("Fail to parse sound pack in id {}", (Object)id);
            e.printStackTrace();
        }
        JeanMod.LOGGER.debug("Loaded {} sound pack.", (Object)id);
    }

    @NotNull
    private static Map<class_2960, List<SoundData>> loadSoundEvent(ZipFile zipFile, String id) {
        LinkedHashMap buffers = Maps.newLinkedHashMap();
        Pattern pattern = Pattern.compile(String.format("assets/%s/sounds/maid/(.*?)/(.*?\\.ogg)", id));
        zipFile.stream().forEach(zipEntry -> {
            String path;
            Matcher matcher;
            if (!zipEntry.isDirectory() && (matcher = pattern.matcher(path = zipEntry.getName())).find()) {
                String subDir = matcher.group(1);
                String fileName = matcher.group(2);
                CustomSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, ModSoundEvents.MAID_IDLE, "mode", "idle");
                CustomSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, ModSoundEvents.SnakeHurt, "ai", "hurt");
                CustomSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, ModSoundEvents.SnakeHurtFire, "ai", "hurt_fire");
                CustomSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, ModSoundEvents.SnakeHurtPlayer, "ai", "hurt_player");
                CustomSoundLoader.loadSounds(zipFile, buffers, zipEntry, subDir, fileName, ModSoundEvents.SnakeDeath, "ai", "death");
            }
        });
        return buffers;
    }

    private static void loadSounds(ZipFile zipFile, Map<class_2960, List<SoundData>> buffers, ZipEntry zipEntry, String subDir, String fileName, class_3414 soundEvent, String checkSubDir, String checkFileName) {
        List sounds = buffers.computeIfAbsent(soundEvent.method_14833(), res -> Lists.newArrayList());
        if (checkSubDir.equals(subDir) && CustomSoundLoader.checkFileName(checkFileName, fileName)) {
            try (InputStream zipEntryStream = zipFile.getInputStream(zipEntry);
                 class_4228 audioStream = new class_4228(zipEntryStream);){
                ByteBuffer bytebuffer = audioStream.method_19721();
                sounds.add(new SoundData(bytebuffer, audioStream.method_19719()));
                JeanMod.LOGGER.debug("sound: {}", (Object)fileName);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

