/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="jean")
public class Config {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    private static final ModConfigSpec.BooleanValue SHOW_MOD_NAME = BUILDER.comment("Show mod name in tooltip.  Default: false").define("showModName", false);
    private static final ModConfigSpec.BooleanValue SHOW_PRESS_KEY_INFO = BUILDER.comment("Show press A or B to show text hint.  Default: false").define("showPressKeyInfo", false);
    private static final ModConfigSpec.BooleanValue ShowAsAdvanced = BUILDER.comment("Show NBT and Tags only if Advanced Tooltips (F3 + h) is on.  Default: false").define("showAsAdvanced", false);
    private static final ModConfigSpec.BooleanValue IsTwelves = BUILDER.comment(new String[]{"Show 12 or 24 hour clock format.  Default: false", "true for 12 hour, false for 24 hour"}).define("isTwelves", false);
    private static final ModConfigSpec.BooleanValue ShowInfoClock = BUILDER.comment("Show Clock Day and Time.  Default: true").define("showInfoClock", true);
    private static final ModConfigSpec.BooleanValue ShowInfoRecovery = BUILDER.comment("Show Recovery Compass players death location.  Default: true").define("showInfoRecovery", true);
    private static final ModConfigSpec.BooleanValue ShowInfoStew = BUILDER.comment("Show Suspicious Stew effects.  Default: true").define("showInfoStew", true);
    private static final ModConfigSpec.BooleanValue ShowInfoBees = BUILDER.comment("Show Bees Nest/Hive information.  Default: true").define("showInfoBees", true);
    private static final ModConfigSpec.ConfigValue<Boolean> AllowBoth = BUILDER.comment("If enabled then the Shift Right Click interaction will not be disabled when the interaction Key is binded").define("AllowBoth", false);
    private static final ModConfigSpec.ConfigValue<List<? extends String>> ITEM_STRINGS = BUILDER.comment("A list of items to log on common setup.").defineListAllowEmpty("items", List.of("minecraft:iron_ingot"), () -> BuiltInRegistries.ITEM.getKey((Object)Items.EGG).toString(), Config::validateItemName);
    private static final ModConfigSpec.DoubleValue MAX_DISTANCE = BUILDER.comment("How far away (in blocks) entities can be to appear in the hud health indicator").translation("max_distance").defineInRange("max_distance", 100.0, 3.0, 10000.0);
    private static final ModConfigSpec.IntValue MAID_WEIGHT = BUILDER.comment(new String[]{"maid weight"}).defineInRange("maidWeight", 3, 0, 100);
    private static final ModConfigSpec.IntValue MAID_MIN = BUILDER.comment(new String[]{"maid min"}).defineInRange("maidMin", 1, 0, 40);
    private static final ModConfigSpec.IntValue MAID_MAX = BUILDER.comment(new String[]{"maid max"}).defineInRange("maidMax", 1, 0, 100);
    private static final ModConfigSpec.IntValue ELF_WEIGHT = BUILDER.comment(new String[]{"maid weight"}).defineInRange("elfWeight", 3, 0, 100);
    private static final ModConfigSpec.IntValue ELF_MIN = BUILDER.comment(new String[]{"maid min"}).defineInRange("elfMin", 1, 0, 40);
    private static final ModConfigSpec.IntValue ELF_MAX = BUILDER.comment(new String[]{"maid max"}).defineInRange("elfMax", 1, 0, 100);
    private static final ModConfigSpec.IntValue GANGSTER_WEIGHT = BUILDER.comment(new String[]{"gangster weight"}).defineInRange("gangsterWeight", 3, 0, 100);
    private static final ModConfigSpec.IntValue GANGSTER_MIN = BUILDER.comment(new String[]{"gangster min"}).defineInRange("gangsterMin", 1, 0, 40);
    private static final ModConfigSpec.IntValue GANGSTER_MAX = BUILDER.comment(new String[]{"gangster max"}).defineInRange("gangsterMax", 1, 0, 100);
    private static final ModConfigSpec.IntValue HUMAN_WEIGHT = BUILDER.comment(new String[]{"human  weight"}).defineInRange("humanWeight", 3, 0, 100);
    private static final ModConfigSpec.IntValue HUMAN_MIN = BUILDER.comment(new String[]{"human  min"}).defineInRange("humanMin", 1, 0, 40);
    private static final ModConfigSpec.IntValue HUMAN_MAX = BUILDER.comment(new String[]{"human  max"}).defineInRange("humanMax", 1, 0, 100);
    public static final ModConfigSpec.ConfigValue<String> DEFAULT_LITTER_CHANCES = BUILDER.comment(" pig have litter chance").define("defaultLitterChances", (Object)"30:2,50:3,15:4,4:5,1:6");
    private static final ModConfigSpec.BooleanValue HEALTH_DECIMALS = BUILDER.comment("Whether health appears with a decimal point.").translation("health_decimals").define("health_decimals", true);
    private static final ModConfigSpec.IntValue ORE_CLEAN_RADIUS = BUILDER.comment("Ore clean item radius.").translation("ore_clean_radius").defineInRange("oreCleanRadius", 10, 10, 300);
    static final ModConfigSpec SPEC = BUILDER.build();
    public static double maxDistance;
    public static boolean healthDecimals;
    public static Set<Item> items;
    public static Boolean allowBoth;
    public static int maidWeight;
    public static int maidMin;
    public static int maidMax;
    public static int gangsterWeight;
    public static int gangsterMin;
    public static int gangsterMax;
    public static int elfWeight;
    public static int elfMin;
    public static int elfMax;
    public static int humanWeight;
    public static int humanMin;
    public static int humanMax;
    public static String defaultLitterChances;
    public static boolean showModName;
    public static boolean showAsAdvanced;
    public static boolean isTwelves;
    public static boolean showInfoClock;
    public static boolean showInfoRecovery;
    public static boolean showInfoStew;
    public static boolean showInfoBees;
    public static boolean showPressKeyInfo;
    public static int oreCleanRadius;

    private static boolean validateItemName(Object obj) {
        String itemName;
        return obj instanceof String && BuiltInRegistries.ITEM.containsKey(ResourceLocation.parse((String)(itemName = (String)obj)));
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        oreCleanRadius = (Integer)ORE_CLEAN_RADIUS.get();
        showModName = (Boolean)SHOW_MOD_NAME.get();
        showAsAdvanced = (Boolean)ShowAsAdvanced.get();
        isTwelves = (Boolean)IsTwelves.get();
        showInfoClock = (Boolean)ShowInfoClock.get();
        showInfoRecovery = (Boolean)ShowInfoRecovery.get();
        showInfoStew = (Boolean)ShowInfoStew.get();
        showInfoBees = (Boolean)ShowInfoBees.get();
        showPressKeyInfo = (Boolean)SHOW_PRESS_KEY_INFO.get();
        maxDistance = (Double)MAX_DISTANCE.get();
        healthDecimals = (Boolean)HEALTH_DECIMALS.get();
        defaultLitterChances = (String)DEFAULT_LITTER_CHANCES.get();
        maidWeight = (Integer)MAID_WEIGHT.get();
        maidMin = (Integer)MAID_MIN.get();
        maidMax = (Integer)MAID_MAX.get();
        humanWeight = (Integer)HUMAN_WEIGHT.get();
        humanMin = (Integer)HUMAN_MIN.get();
        humanMax = (Integer)HUMAN_MAX.get();
        elfWeight = (Integer)ELF_WEIGHT.get();
        elfMin = (Integer)ELF_MIN.get();
        elfMax = (Integer)ELF_MAX.get();
        gangsterWeight = (Integer)GANGSTER_WEIGHT.get();
        gangsterMin = (Integer)GANGSTER_MIN.get();
        gangsterMax = (Integer)GANGSTER_MAX.get();
        items = ((List)ITEM_STRINGS.get()).stream().map(itemName -> (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)itemName))).collect(Collectors.toSet());
        allowBoth = (Boolean)AllowBoth.get();
    }
}

