/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.bind;

import com.yzqdev.mod.jeanmod.bind.CommandItemScreen;
import com.yzqdev.mod.jeanmod.components.ModDataComponents;
import com.yzqdev.mod.jeanmod.datagen.LangDefinition;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class CommandItem
extends Item {
    public CommandItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public ItemStack getDefaultInstance() {
        ItemStack itemStack = new ItemStack((ItemLike)this);
        MutableComponent defaultName = Component.translatable((String)LangDefinition.command_item);
        itemStack.set(DataComponents.CUSTOM_NAME, (Object)defaultName);
        return itemStack;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        if (level.isClientSide()) {
            if (player.isShiftKeyDown()) {
                this.openClientGui(player.getItemInHand(hand), player);
            }
            return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(hand), (boolean)true);
        }
        if (!player.isShiftKeyDown()) {
            this.executeCommand(level, player, hand);
        }
        return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(hand), (boolean)false);
    }

    private void executeCommand(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        CommandSourceStack commandSource = player.createCommandSourceStack();
        String command = (String)stack.get(ModDataComponents.CommandNbt);
        if (level.getServer() != null && command != null) {
            level.getServer().getCommands().performPrefixedCommand(commandSource, command);
            MutableComponent cmdText = Component.literal((String)command).setStyle(Style.EMPTY.withColor(ChatFormatting.RED));
            player.sendSystemMessage((Component)Component.translatable((String)LangDefinition.run_command).append((Component)cmdText));
        } else {
            player.sendSystemMessage((Component)Component.literal((String)"error level.getServer() = null"));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openClientGui(ItemStack stack, Player player) {
        Minecraft.getInstance().execute(() -> Minecraft.getInstance().setScreen((Screen)new CommandItemScreen(player.getMainHandItem())));
    }
}

