/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.block.entity;

import com.yzqdev.mod.jeanmod.block.ModBlockEntities;
import com.yzqdev.mod.jeanmod.inventory.CompressedBarrelsMenu;
import com.yzqdev.mod.jeanmod.network.ItemStackSyncS2CPacket;
import io.netty.buffer.Unpooled;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class CompressedBarrelsBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer {
    private NonNullList<ItemStack> items = NonNullList.withSize((int)195, (Object)ItemStack.EMPTY);
    private final ItemStackHandler itemHandler = new ItemStackHandler(195){

        protected void onContentsChanged(int slot) {
            CompressedBarrelsBlockEntity.this.setChanged();
            CompressedBarrelsBlockEntity.this.setItems((NonNullList<ItemStack>)this.stacks);
            if (!((CompressedBarrelsBlockEntity)CompressedBarrelsBlockEntity.this).level.isClientSide) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new ItemStackSyncS2CPacket(CompressedBarrelsBlockEntity.this.worldPosition), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return true;
        }
    };

    public CompressedBarrelsBlockEntity(BlockPos position, BlockState state) {
        super((BlockEntityType)ModBlockEntities.COMPRESSED_BARRELS.get(), position, state);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (!this.trySaveLootTable(tag)) {
            this.itemHandler.serializeNBT(registries);
            ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(tag)) {
            this.itemHandler.deserializeNBT(registries, tag);
            ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        }
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public Component getDefaultName() {
        return Component.translatable((String)"block.jean.compressed_barrels");
    }

    public int getMaxStackSize() {
        return 64;
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory) {
        return new CompressedBarrelsMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(this.worldPosition));
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.jean.compressed_barrels");
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> stacks) {
        this.items = stacks;
    }

    public int[] getSlotsForFace(Direction side) {
        return IntStream.range(0, this.getContainerSize()).toArray();
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack stack, @Nullable Direction direction) {
        return this.canPlaceItem(index, stack);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public void setRemoved() {
        super.setRemoved();
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }
}

