/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.yzqdev.mod.jeanmod.datagen.LangDefinition;
import com.yzqdev.mod.jeanmod.entity.maid.Maid;
import com.yzqdev.mod.jeanmod.util.ItemUtil;
import com.yzqdev.mod.jeanmod.util.MobUtil;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class CommandJeanChest {
    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        LiteralArgumentBuilder chest = Commands.literal((String)"chest");
        chest.then(Commands.literal((String)"make").executes(context -> CommandJeanChest.moveItemsToChest(((CommandSourceStack)context.getSource()).getPlayerOrException())));
        chest.then(Commands.literal((String)"in").executes(context -> CommandJeanChest.transferItemsToContainer(((CommandSourceStack)context.getSource()).getPlayerOrException())));
        chest.then(Commands.literal((String)"drop").executes(context -> CommandJeanChest.dropPlayerItems(((CommandSourceStack)context.getSource()).getPlayerOrException())));
        chest.then(Commands.literal((String)"maid").executes(context -> CommandJeanChest.playerItemsToMaid(((CommandSourceStack)context.getSource()).getPlayerOrException())));
        return chest;
    }

    private static int playerItemsToMaid(ServerPlayer player) {
        Maid maid = MobUtil.getNearestPlayerMaid((Player)player, 10);
        if (maid != null) {
            Inventory playerInventory = player.getInventory();
            int transferred = 0;
            for (int slot = 0; slot < playerInventory.getContainerSize(); ++slot) {
                ItemStack remaining;
                ItemStack stack = playerInventory.getItem(slot);
                if (stack.isEmpty() || (remaining = maid.getInventory().addItem(stack.copy())).getCount() >= stack.getCount()) continue;
                transferred += stack.getCount() - remaining.getCount();
                playerInventory.setItem(slot, remaining);
            }
            if (transferred > 0) {
                player.sendSystemMessage((Component)Component.translatable((String)LangDefinition.success_transfer_item, (Object[])new Object[]{transferred}), false);
            } else {
                player.sendSystemMessage((Component)Component.translatable((String)LangDefinition.container_full), false);
            }
        }
        return 1;
    }

    private static int dropPlayerItems(ServerPlayer player) {
        player.getInventory().items.forEach(i -> ItemUtil.dropItemRandom(player.level(), i, (LivingEntity)player));
        return 1;
    }

    private static int moveItemsToChest(ServerPlayer player) {
        Direction playerFacing = player.getDirection();
        Direction face = player.getDirection();
        BlockPos playerPos = player.blockPosition();
        BlockPos leftPos = playerPos.relative(face);
        Level level = player.level();
        if (level.isEmptyBlock(leftPos)) {
            BlockPos rightPos = leftPos.relative(face.getClockWise());
            if (!level.getBlockState(leftPos).canBeReplaced() || !level.getBlockState(rightPos).canBeReplaced()) {
                return 0;
            }
            level.setBlock(leftPos, (BlockState)((BlockState)Blocks.CHEST.defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)face)).setValue((Property)ChestBlock.TYPE, (Comparable)ChestType.LEFT), 3);
            level.setBlock(rightPos, (BlockState)((BlockState)Blocks.CHEST.defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)face)).setValue((Property)ChestBlock.TYPE, (Comparable)ChestType.RIGHT), 3);
            IItemHandler containerHandler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, leftPos, (Object)Direction.NORTH);
            if (containerHandler != null) {
                Inventory playerInventory = player.getInventory();
                int transferred = 0;
                for (int slot = 0; slot < playerInventory.getContainerSize(); ++slot) {
                    ItemStack remaining;
                    ItemStack stack = playerInventory.getItem(slot);
                    if (stack.isEmpty() || (remaining = ItemUtil.transferItem(stack.copy(), containerHandler)).getCount() >= stack.getCount()) continue;
                    transferred += stack.getCount() - remaining.getCount();
                    playerInventory.setItem(slot, remaining);
                }
                if (transferred > 0) {
                    player.sendSystemMessage((Component)Component.translatable((String)LangDefinition.success_transfer_item, (Object[])new Object[]{transferred}), false);
                } else {
                    player.sendSystemMessage((Component)Component.translatable((String)LangDefinition.container_full), false);
                }
            }
        }
        return 0;
    }

    private static int transferItemsToContainer(ServerPlayer player) {
        BlockHitResult hitResult = CommandJeanChest.getTargetBlock(player, 5.0);
        if (hitResult.getType() != HitResult.Type.BLOCK) {
            player.sendSystemMessage((Component)Component.translatable((String)LangDefinition.cusor_to_a_block), false);
            return 0;
        }
        BlockPos pos = hitResult.getBlockPos();
        Level level = player.level();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity == null) {
            player.sendSystemMessage((Component)Component.translatable((String)LangDefinition.box_not_a_container), false);
            return 0;
        }
        IItemHandler containerHandler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)Direction.NORTH);
        if (containerHandler == null) {
            player.sendSystemMessage((Component)Component.translatable((String)LangDefinition.box_not_a_container), false);
            return 0;
        }
        Inventory playerInventory = player.getInventory();
        int transferred = 0;
        for (int slot = 0; slot < playerInventory.getContainerSize(); ++slot) {
            ItemStack remaining;
            ItemStack stack = playerInventory.getItem(slot);
            if (stack.isEmpty() || (remaining = ItemUtil.transferItem(stack.copy(), containerHandler)).getCount() >= stack.getCount()) continue;
            transferred += stack.getCount() - remaining.getCount();
            playerInventory.setItem(slot, remaining);
        }
        if (transferred > 0) {
            player.sendSystemMessage((Component)Component.translatable((String)LangDefinition.success_transfer_item, (Object[])new Object[]{transferred}), false);
        } else {
            player.sendSystemMessage((Component)Component.translatable((String)LangDefinition.container_full), false);
        }
        return 1;
    }

    public static BlockHitResult getTargetBlock(ServerPlayer player, double maxDistance) {
        Vec3 start = player.getEyePosition(1.0f);
        Vec3 look = player.getViewVector(1.0f);
        Vec3 end = start.add(look.x * maxDistance, look.y * maxDistance, look.z * maxDistance);
        ClipContext context = new ClipContext(start, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player);
        return player.level().clip(context);
    }
}

