/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.yzqdev.mod.jeanmod.datagen.LangDefinition;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class CopyCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        LiteralArgumentBuilder pack = Commands.literal((String)"copy");
        pack.then(Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(CopyCommand::copyItem));
        return pack;
    }

    public static int copyItem(CommandContext<CommandSourceStack> command) {
        Entity entity = ((CommandSourceStack)command.getSource()).getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int count = IntegerArgumentType.getInteger(command, (String)"count");
            ItemStack heldItem = player.getMainHandItem();
            if (heldItem.isEmpty()) {
                player.sendSystemMessage((Component)Component.translatable((String)LangDefinition.no_item_in_hand));
                return 0;
            }
            ItemStack copy = heldItem.copy();
            copy.setCount(count);
            player.addItem(copy);
            player.sendSystemMessage((Component)Component.translatable((String)LangDefinition.success_copy_item, (Object[])new Object[]{count}));
        }
        return 1;
    }
}

