/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.yzqdev.mod.jeanmod.command.ClipboardHelper;
import com.yzqdev.mod.jeanmod.datagen.LangDefinition;
import com.yzqdev.mod.jeanmod.util.ItemUtil;
import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class NbtCommands {
    public static LiteralArgumentBuilder<CommandSourceStack> get(CommandBuildContext context) {
        LiteralArgumentBuilder cmd = (LiteralArgumentBuilder)Commands.literal((String)"tag").requires(sourceStack -> sourceStack.hasPermission(2));
        cmd.then(((LiteralArgumentBuilder)Commands.literal((String)"copy").then(Commands.argument((String)"slot", (ArgumentType)IntegerArgumentType.integer((int)0, (int)40)).then(Commands.argument((String)"tags", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> NbtCommands.nbtCopy(IntegerArgumentType.getInteger((CommandContext)ctx, (String)"slot"), BoolArgumentType.getBool((CommandContext)ctx, (String)"tags")))))).then(Commands.literal((String)"current_item").then(Commands.argument((String)"tags", (ArgumentType)BoolArgumentType.bool()).executes(context2 -> NbtCommands.nbtCopy(-1, BoolArgumentType.getBool((CommandContext)context2, (String)"tags"))))));
        return cmd;
    }

    public static int nbtCopy(int slot, boolean showTags) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return 0;
        }
        ItemStack itemStack = slot == -1 ? player.getInventory().getSelected() : player.getInventory().getItem(slot);
        if (itemStack.isEmpty()) {
            player.displayClientMessage((Component)Component.translatable((String)LangDefinition.slot_is_empty), false);
            return 1;
        }
        StringBuilder st = new StringBuilder();
        if (!itemStack.getComponents().isEmpty()) {
            itemStack.getComponents().forEach(component -> st.append(component.type()).append(" = ").append(component.value()).append("\n"));
        }
        if (showTags) {
            Collection<ResourceLocation> iTag2;
            Block block;
            Collection<ResourceLocation> iTag = ItemUtil.getTags(itemStack.getTags());
            if (!iTag.isEmpty()) {
                st.append("\n").append(Component.translatable((String)LangDefinition.item_tags).getString()).append("\n");
                for (ResourceLocation tag : iTag) {
                    st.append(" #").append(tag.toString()).append("\n");
                }
            }
            if ((block = Block.byItem((Item)itemStack.getItem())) != Blocks.AIR && !(iTag2 = ItemUtil.getTags(block.defaultBlockState().getTags())).isEmpty()) {
                st.append(Component.translatable((String)LangDefinition.block_tags).getString()).append("\n");
                for (ResourceLocation tag2 : iTag2) {
                    st.append(" #").append(tag2.toString()).append("\n");
                }
            }
        }
        if (st.isEmpty()) {
            player.displayClientMessage((Component)Component.translatable((String)LangDefinition.copied_no, (Object[])new Object[]{itemStack.getHoverName().copy().withStyle(ChatFormatting.DARK_GREEN)}), false);
            return 1;
        }
        st.insert(0, itemStack.getHoverName().getString() + "\n" + itemStack.getItemHolder().getRegisteredName() + "\n\n");
        ClipboardHelper.copyToClipboard(st.toString());
        player.displayClientMessage((Component)Component.translatable((String)LangDefinition.copied, (Object[])new Object[]{itemStack.getHoverName().copy().withStyle(ChatFormatting.DARK_GREEN)}), false);
        return 1;
    }
}

