/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.command;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class SummonCommand {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.summon.failed"));
    private static final SimpleCommandExceptionType ERROR_DUPLICATE_UUID = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.summon.failed.uuid"));
    private static final SimpleCommandExceptionType INVALID_POSITION = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.summon.invalidPosition"));

    public static LiteralArgumentBuilder<CommandSourceStack> get(CommandBuildContext context) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"summon").requires(p_138819_ -> p_138819_.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"entity", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, (ResourceKey)Registries.ENTITY_TYPE)).suggests(SuggestionProviders.SUMMONABLE_ENTITIES).executes(p_248175_ -> SummonCommand.spawnEntity((CommandSourceStack)p_248175_.getSource(), ResourceArgument.getSummonableEntityType((CommandContext)p_248175_, (String)"entity"), 50, new CompoundTag(), true))).then(Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer()).executes(cmd -> SummonCommand.spawnEntity((CommandSourceStack)cmd.getSource(), ResourceArgument.getSummonableEntityType((CommandContext)cmd, (String)"entity"), IntegerArgumentType.getInteger((CommandContext)cmd, (String)"count"), new CompoundTag(), true))));
    }

    public static Entity createEntity(CommandSourceStack source, Holder.Reference<EntityType<?>> type, Vec3 pos, CompoundTag tag, boolean randomizeProperties) throws CommandSyntaxException {
        BlockPos blockpos = BlockPos.containing((Position)pos);
        if (!Level.isInSpawnableBounds((BlockPos)blockpos)) {
            throw INVALID_POSITION.create();
        }
        CompoundTag compoundtag = tag.copy();
        compoundtag.putString("id", type.key().location().toString());
        ServerLevel serverlevel = source.getLevel();
        Entity entity = EntityType.loadEntityRecursive((CompoundTag)compoundtag, (Level)serverlevel, p_138828_ -> {
            p_138828_.moveTo(pos.x, pos.y, pos.z, p_138828_.getYRot(), p_138828_.getXRot());
            return p_138828_;
        });
        if (entity == null) {
            throw ERROR_FAILED.create();
        }
        if (randomizeProperties && entity instanceof Mob) {
            Mob mob = (Mob)entity;
            EventHooks.finalizeMobSpawn((Mob)mob, (ServerLevelAccessor)source.getLevel(), (DifficultyInstance)source.getLevel().getCurrentDifficultyAt(entity.blockPosition()), (MobSpawnType)MobSpawnType.COMMAND, null);
        }
        if (!serverlevel.tryAddFreshEntityWithPassengers(entity)) {
            throw ERROR_DUPLICATE_UUID.create();
        }
        return entity;
    }

    private static int spawnEntity(CommandSourceStack source, Holder.Reference<EntityType<?>> type, int count, CompoundTag tag, boolean randomizeProperties) {
        ServerPlayer player = source.getPlayer();
        Level level = player.level();
        Vec3 pos = player.getEyePosition();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("summon-animal-pool-%d").build();
        try (ThreadPoolExecutor thread = new ThreadPoolExecutor(4, 8, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1000), namedThreadFactory);){
            for (int i = 0; i < count; ++i) {
                thread.execute(() -> {
                    double x = player.getX() + (random.nextDouble() - 0.5) * 5.0;
                    double z = player.getZ() + (random.nextDouble() - 0.5) * 5.0;
                    double y = player.getY();
                    level.getServer().execute(() -> {
                        try {
                            SummonCommand.createEntity(source, type, new Vec3(x, y, z), tag, randomizeProperties);
                        }
                        catch (CommandSyntaxException e) {
                            e.printStackTrace();
                        }
                    });
                });
            }
        }
        Entity entity = ((EntityType)type.value()).create(player.level());
        source.sendSuccess(() -> Component.translatable((String)"commands.summon.success", (Object[])new Object[]{entity == null ? "" : entity.getDisplayName()}), true);
        return 1;
    }
}

