/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.compat.jade;

import com.yzqdev.mod.jeanmod.datagen.LangDefinition;
import com.yzqdev.mod.jeanmod.entity.elf.EntityElf;
import com.yzqdev.mod.jeanmod.entity.maid.Maid;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.item.ItemStack;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;

public enum MaidInvProvider implements IEntityComponentProvider,
IServerDataProvider<EntityAccessor>
{
    INSTANCE;

    private static final ResourceLocation MAID_INV;

    public void appendTooltip(ITooltip iTooltip, EntityAccessor entityAccessor, IPluginConfig iPluginConfig) {
        TamableAnimal maid;
        Entity entity = entityAccessor.getEntity();
        if (entity instanceof Maid) {
            ListTag itemTags;
            maid = (Maid)entity;
            CompoundTag data = entityAccessor.getServerData();
            if (data.contains("inv") && !(itemTags = data.getList("inv", 10)).isEmpty()) {
                iTooltip.add((Component)Component.translatable((String)LangDefinition.maid_backpack_content));
                iTooltip.add((Component)Component.literal((String)""));
                ArrayList allItem = new ArrayList(itemTags);
                List finalList = MaidInvProvider.splitIntoChunks(allItem, 10);
                finalList.forEach(arg_0 -> MaidInvProvider.lambda$appendTooltip$0((Maid)maid, iTooltip, arg_0));
            }
        }
        if ((entity = entityAccessor.getEntity()) instanceof EntityElf && (maid = (EntityElf)entity).isTame()) {
            iTooltip.add((Component)Component.translatable((String)LangDefinition.sit_status).append(String.valueOf(maid.isInSittingPose())));
        }
    }

    public static <T> List<List<T>> splitIntoChunks(List<T> source, int chunkSize) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        for (int i = 0; i < source.size(); i += chunkSize) {
            int end = Math.min(i + chunkSize, source.size());
            result.add(source.subList(i, end));
        }
        return result;
    }

    public ResourceLocation getUid() {
        return MAID_INV;
    }

    public void appendServerData(CompoundTag compoundTag, EntityAccessor entityAccessor) {
        Entity entity = entityAccessor.getEntity();
        if (entity instanceof Maid) {
            Maid maid = (Maid)entity;
            ArrayList itemStacks = new ArrayList();
            SimpleContainer maidInv = maid.getInventory();
            ListTag listTag = new ListTag();
            for (int i = 0; i < maidInv.getContainerSize(); ++i) {
                ItemStack itemStack = maidInv.getItem(i);
                if (itemStack.isEmpty()) continue;
                ItemStack copyedItem = itemStack.copy();
                CompoundTag tag = new CompoundTag();
                tag.putInt("count", copyedItem.getCount());
                tag.putString("id", BuiltInRegistries.ITEM.getKey((Object)copyedItem.getItem()).toString());
                if (listTag.size() > 54) break;
                listTag.add((Object)tag);
            }
            compoundTag.put("inv", (Tag)listTag);
        }
    }

    private static /* synthetic */ void lambda$appendTooltip$0(Maid maid, ITooltip iTooltip, List i) {
        for (Tag item : i) {
            IElementHelper elements = IElementHelper.get();
            IElement icon = elements.item(ItemStack.parseOptional((HolderLookup.Provider)maid.registryAccess(), (CompoundTag)((CompoundTag)item)), 0.8f);
            iTooltip.append(icon);
        }
        iTooltip.add((Component)Component.literal((String)""));
    }

    static {
        MAID_INV = ResourceLocation.fromNamespaceAndPath((String)"jean", (String)"maid_inv");
    }
}

